/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Locale;
import latitude.api.expression.Expression;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;

public enum FunctionDefinition {
    ABS(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Computes the absolute value"),
    ACOS(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the inverse cosine of the given value"),
    ADD_MONTHS(2, Expression.ReturnType.DATE, FunctionType.TRANSFORM, "Returns the date that is arg1 months after arg0"),
    PERCENTILE_APPROX(2, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Return the value in the column arg0 at the arg1 percentile"),
    ARRAY(-1, Expression.ReturnType.ARRAY, FunctionType.TRANSFORM, "Creates an array of all the input columns"),
    ASIN(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the inverse sine of the given column"),
    ATAN(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the inverse tangent of the given value"),
    ARRAY_AGG(1, Expression.ReturnType.ARRAY, FunctionType.AGGREGATING, "Aggregate function: returns an array of aggregated values from the input column"),
    ARRAY_AGG_DISTINCT(1, Expression.ReturnType.ARRAY, FunctionType.AGGREGATING, "Aggregate function: returns an array of distinct aggregated values from the input column"),
    ARRAY_CONTAINS(2, Expression.ReturnType.BOOLEAN, FunctionType.TRANSFORM, "Returns true if the array column arg0 contains value arg1"),
    ARRAY_DISTINCT(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the array column arg0 without duplicate elements"),
    ARRAY_EXCEPT(2, Expression.ReturnType.ARRAY, FunctionType.TRANSFORM, "Returns the input array arg0 without any element from array arg1"),
    ARRAY_FLATTEN(1, Expression.ReturnType.INNER_TYPE_FROM_INPUT, FunctionType.TRANSFORM, "Returns a single array from the array of arrays arg0"),
    ARRAY_GET_AT_INDEX(2, Expression.ReturnType.INNER_TYPE_FROM_INPUT, FunctionType.TRANSFORM, "Returns the element at index arg1 (1-indexed) from array column arg0 (explicitly cast the result of this function to use in subsequent boards)"),
    ARRAY_INTERSECT(2, Expression.ReturnType.ARRAY, FunctionType.TRANSFORM, "Returns the intersection of the array column arg0 and the array column arg1"),
    ARRAYS_OVERLAP(2, Expression.ReturnType.BOOLEAN, FunctionType.TRANSFORM, "Returns true if the array column arg0 and the array column arg1 have at least one non-null element in common"),
    ARRAY_LENGTH(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Returns the length of the given array"),
    ARRAY_JOIN(2, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Returns a string of the array column arg0 joined by the separator string arg1 (note: arg1 must be a string literal)"),
    ARRAY_REGEX_REPLACE(3, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the input string array arg0, with all substrings matching regex arg1 replaced with arg2 in every element"),
    ARRAY_REPLACE(3, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the input array arg0 with all elements equal to arg1 replaced with arg2"),
    ARRAY_SORT(2, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Sorts the input array arg0 in ascending order if arg1 is true, or descending order if arg1 is false"),
    AVG(1, Expression.ReturnType.NUMBER, FunctionType.AGGREGATING, "Aggregate function: returns the average of the values in a group"),
    CBRT(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the cube-root of the given value"),
    CEIL(1, Expression.ReturnType.NUMBER, FunctionType.TRANSFORM, "Computes the ceiling of the given value"),
    COALESCE(-1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the first column that is not null, or null if all inputs are null"),
    CONCAT(-1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Concatenates multiple input string columns together into a single string column, returning null if any input column is null"),
    CONCAT_WS(-1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Concatenates multiple input string columns together into a single string column, using arg0 as a separator"),
    CORR(2, Expression.ReturnType.DOUBLE, FunctionType.AGGREGATING, "Aggregate function: returns the Pearson Correlation Coefficient for two columns"),
    COS(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the cosine of the given value"),
    COUNT(1, Expression.ReturnType.LONG, FunctionType.AGGREGATING, "Aggregate function: returns the number of items in a group"),
    COUNT_DISTINCT(-1, Expression.ReturnType.LONG, FunctionType.AGGREGATING, "Aggregate function: returns the number of distinct items in a group"),
    CUME_DIST(0, Expression.ReturnType.DOUBLE, FunctionType.AGGREGATING, "Window function: returns the cumulative distribution of values within a window partition, i.e. the fraction of rows that are below the current row."),
    CURRENT_DATE(0, Expression.ReturnType.DATE, FunctionType.TRANSFORM, "Returns the current date as a date column."),
    CURRENT_TIMESTAMP(0, Expression.ReturnType.TIMESTAMP, FunctionType.TRANSFORM, "Returns the current timestamp as a timestamp column"),
    CURRENT_UNIX_TIMESTAMP(0, Expression.ReturnType.LONG, FunctionType.TRANSFORM, "Returns the current timestamp as number in seconds"),
    DATE_ADD(2, Expression.ReturnType.DATE, FunctionType.TRANSFORM, "Returns the date that is arg1 days after arg0"),
    DATE_FORMAT(2, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Converts a date/timestamp arg0 to a string in the format specified by arg1, following https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html"),
    DATE_SUB(2, Expression.ReturnType.DATE, FunctionType.TRANSFORM, "Returns the date that is arg1 days before arg0"),
    DATE_DIFF(2, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Returns the number of days from arg1 to arg0"),
    DATE_TRUNC(2, Expression.ReturnType.TIMESTAMP, FunctionType.TRANSFORM, "Returns arg1 truncated to the unit specified by arg0"),
    DAY_OF_MONTH(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the day of the month as an integer from a given date/timestamp/string"),
    DAY_OF_WEEK(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the day of the week as an integer from a given date/timestamp/string.Ranges from 1 for a Sunday through to 7 for a Saturday"),
    DAY_OF_YEAR(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the day of the year as an integer from a given date/timestamp/string"),
    DENSE_RANK(0, Expression.ReturnType.INTEGER, FunctionType.AGGREGATING, "Window function: returns the rank of rows within a window partition, without any gaps."),
    EXP(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the exponential of the given value"),
    EXPLODE(1, Expression.ReturnType.INNER_TYPE_FROM_INPUT, FunctionType.TRANSFORM, "Creates a new row for each element in the given array column, dropping rows with nulls (explicitly cast the result of this function to use in subsequent boards)"),
    EXPLODE_OUTER(1, Expression.ReturnType.INNER_TYPE_FROM_INPUT, FunctionType.TRANSFORM, "Creates a new row for each element in the given array column (explicitly cast the result of this function to use in subsequent boards)"),
    FACTORIAL(1, Expression.ReturnType.LONG, FunctionType.TRANSFORM, "Computes the factorial of the given value"),
    FIRST(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Window function: returns the first value in a group"),
    FLOOR(1, Expression.ReturnType.NUMBER, FunctionType.TRANSFORM, "Computes the floor of the given value"),
    FORMAT_NUMBER(2, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Formats numeric column arg0 to a format like '#,###,###.##', rounded to arg1 decimal places, and returns the result as a string column"),
    FORMAT_STRING(-1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Formats the arguments according to https://docs.oracle.com/javase/7/docs/api/java/util/Formatter.html and returns the result as a string column"),
    FROM_UTC_TIMESTAMP(2, Expression.ReturnType.TIMESTAMP, FunctionType.TRANSFORM, "Given a timestamp column arg0, which corresponds to a certain time of day in UTC, returns another timestamp that corresponds to the same time of day in the given timezone arg1."),
    GET_JSON_OBJECT(2, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Extracts json object from a json string arg0 based on json path (https://github.com/json-path/JsonPath) arg1, and returns json string of the extracted json object. Returns null if either arg is invalid."),
    GREATEST(-1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the greatest value of the list of values, skipping null values"),
    HASH(-1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Calculates the hash code of given columns, and returns the result as an int column"),
    HOUR(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the hours as an integer from a given date/timestamp/string"),
    INITCAP(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Returns the string with the first letter of each word in uppercase, all other letters in lowercase. Words are delimited by whitespace."),
    INSTR(2, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Returns the (1-based) index of the first occurrence of arg1 in arg0."),
    ISNAN(1, Expression.ReturnType.BOOLEAN, FunctionType.TRANSFORM, "Return true iff the column is NaN"),
    ISNULL(1, Expression.ReturnType.BOOLEAN, FunctionType.TRANSFORM, "Return true iff the column is null"),
    LAG(2, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Window function: returns the value that is arg1 rows before the current row in column arg0, and null if there are less than arg1 rows before the current row. For example, an arg1 of one will return the previous row at any given point in the window partition."),
    LAST_DAY(1, Expression.ReturnType.DATE, FunctionType.TRANSFORM, "Given a date column, returns the date on the last day of the month which the given date belongs to"),
    LAST(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Window function: returns the last value in a group"),
    LEAD(2, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Window function: returns the value that is arg1 rows after the current row in column arg0, and null if there are less than arg1 rows after the current row. For example, an arg1 of one will return the next row at any given point in the window partition."),
    LEAST(-1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the least value of the list of values, skipping null values"),
    LENGTH(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Computes the length of a given string or binary column"),
    LEVENSHTEIN(2, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Computes the Levenshtein distance of the two given string columns"),
    LN(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the natural logarithm of the given value"),
    LOG(2, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the logarithm of the arg1 with a base of the arg0"),
    LOWER(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Converts a string column to lower case"),
    LPAD(3, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Returns the string column arg0, left-padded up to length arg1, with the string arg2"),
    LTRIM(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Trim the spaces from left end for the specified string value. Tab and newline characters are not affected."),
    MAX(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Aggregate function: returns the maximum value of the expression in a group"),
    MD5(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Calculates the MD5 digest of a binary column and returns the value as a 32 character hex string"),
    MEAN(1, Expression.ReturnType.NUMBER, FunctionType.AGGREGATING, "Aggregate function: returns the average of the values in a group"),
    MIN(1, Expression.ReturnType.SAME_AS_INPUT, FunctionType.AGGREGATING, "Aggregate function: returns the minimum value of the expression in a group"),
    MINUTE(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the minutes as an integer from a given date/timestamp/string"),
    MONOTONICALLY_INCREASING_ID(0, Expression.ReturnType.LONG, FunctionType.TRANSFORM, "Returns a monotonically increasing id"),
    MONTH(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the month as an integer from a given date/timestamp/string"),
    MONTHS_BETWEEN(2, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Returns number of months between dates arg0 and arg1"),
    NTILE(1, Expression.ReturnType.INTEGER, FunctionType.AGGREGATING, "Window function: returns the ntile group id (from 1 to arg0 inclusive) in an ordered window partition. For example, if arg0 is 4, the first quarter of the rows will get value 1, the second quarter will get 2, the third quarter will get 3, and the last quarter will get 4."),
    PERCENT_RANK(0, Expression.ReturnType.DOUBLE, FunctionType.AGGREGATING, "Window function: returns the relative rank (i.e. percentile) of rows within a window partition."),
    POW(2, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Returns the value of the arg0 raised to the power of arg1"),
    QUARTER(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the quarter as an integer from a given date/timestamp/string"),
    RAND(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Returns a random number between 0 and 1 for each row, based on the provided seed"),
    RANK(0, Expression.ReturnType.INTEGER, FunctionType.AGGREGATING, "Window function: returns the rank of rows within a window partition."),
    REGEXP_EXTRACT(3, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Extract a specific group arg2 (1-indexed) matched by a Java regex arg1, from the specified string column arg0, using parentheses to delineate groups.  To extract the entire match, set arg2 to 0.  If the regex did not match, or the specified group did not match, an empty string is returned."),
    REGEXP_REPLACE(3, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Replace all substrings in arg0 that match arg1 with arg2"),
    REVERSE(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Reverses the string column and returns it as a new string column"),
    ROUND(2, Expression.ReturnType.SAME_AS_INPUT, FunctionType.TRANSFORM, "Returns the value of arg0 rounded to arg1 decimal places"),
    ROW_NUMBER(0, Expression.ReturnType.INTEGER, FunctionType.AGGREGATING, "Window function: returns a sequential number starting at 1 within a window partition."),
    RPAD(3, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Returns the string column arg0, right-padded up to length arg1, with the string arg2"),
    RTRIM(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Trim the spaces from right end for the specified string value. Tab and newline characters are not affected."),
    SECOND(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the seconds as an integer from a given date/timestamp/string"),
    SHA1(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Calculates the SHA-1 digest of a binary column and returns the value as a 40 character hex string"),
    SIN(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the sine of the given column"),
    SOUNDEX(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Computes a soundex phonetic representation of the specified string. Useful for fuzzy matching"),
    SPLIT(2, Expression.ReturnType.ARRAY, FunctionType.TRANSFORM, "Splits string column arg0 around regex pattern string arg1"),
    SQRT(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the square root of the specified float value"),
    STDDEV(1, Expression.ReturnType.DOUBLE, FunctionType.AGGREGATING, "Aggregate function: returns the sample standard deviation of the expression in a group"),
    SUBSTRING(3, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Substring of arg0, starting at index arg1 (1-indexed) and of length arg2"),
    SUM(1, Expression.ReturnType.NUMBER, FunctionType.AGGREGATING, "Aggregate function: returns the sum of all values in the expression"),
    SUM_DISTINCT(1, Expression.ReturnType.NUMBER, FunctionType.AGGREGATING, "Aggregate function: returns the sum of distinct values in the expression"),
    TAN(1, Expression.ReturnType.DOUBLE, FunctionType.TRANSFORM, "Computes the tangent of the given value"),
    TO_UNIX_TIMESTAMP(2, Expression.ReturnType.LONG, FunctionType.TRANSFORM, "Convert time string arg0 with given pattern string arg1 to Unix time stamp (in seconds)"),
    TO_UTC_TIMESTAMP(2, Expression.ReturnType.TIMESTAMP, FunctionType.TRANSFORM, "Given a timestamp column arg0, which corresponds to a certain time of day in the given timezone arg1, returns another timestamp that corresponds to the same time of day in UTC."),
    TRIM(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Trim the spaces from both ends for the specified string column. Tab and newline characters are not affected."),
    UPPER(1, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "Converts a string column to upper case"),
    VARIANCE(1, Expression.ReturnType.DOUBLE, FunctionType.AGGREGATING, "Aggregate function: returns the unbiased variance of the values in a group"),
    WEEK_OF_YEAR(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the ISO week number as an integer from a given date/timestamp/string"),
    YEAR(1, Expression.ReturnType.INTEGER, FunctionType.TRANSFORM, "Extracts the year as an integer from a given date/timestamp/string"),
    UNKNOWN(0, Expression.ReturnType.STRING, FunctionType.TRANSFORM, "unknown");

    private static final SafeLogger log;
    private final int numArgs;
    private final Expression.ReturnType returnType;
    private final FunctionType functionType;
    private final String documentation;

    private FunctionDefinition(int numArgs, Expression.ReturnType returnType, FunctionType functionType, String documentation) {
        this.numArgs = numArgs;
        this.returnType = returnType;
        this.functionType = functionType;
        this.documentation = documentation;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public Expression.ReturnType getReturnType() {
        return this.returnType;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    @JsonCreator
    public static FunctionDefinition parse(String function) {
        try {
            return FunctionDefinition.valueOf(function.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown value '{}' found for FunctionDefinition. Defaulting to UNKNOWN.", UnsafeArg.of("unknownFunctionDefinition", function), (Throwable)e);
            return UNKNOWN;
        }
    }

    static {
        log = SafeLoggerFactory.get(FunctionDefinition.class);
    }

    public static enum FunctionType {
        AGGREGATING,
        TRANSFORM;

    }
}

