/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.ColumnAttribute;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Expression;
import latitude.api.expression.Expressions;
import latitude.api.expression.FunctionDefinition;
import latitude.api.expression.FunctionWindow;
import latitude.api.expression.ImmutableFunctionExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.representation.ExpressionStringBuilder;
import latitude.api.expression.representation.FunctionWindowRepresentation;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.base.Joiner;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableFunctionExpression.class)
@JsonSerialize(as=ImmutableFunctionExpression.class)
@Value.Immutable
public abstract class FunctionExpression
extends Expression {
    public static final int FUNCTION_ACCEPTS_VARARGS = -1;

    public static FunctionExpression of(FunctionDefinition function, List<Expression> arguments, Optional<FunctionWindow> window) {
        return ImmutableFunctionExpression.of(function, arguments, window);
    }

    @Override
    public final List<String> getSourceTables() {
        ImmutableSet.Builder sourceTables = ImmutableSet.builder();
        for (Expression expression : this.arguments()) {
            sourceTables.addAll(expression.getSourceTables());
        }
        return ImmutableList.copyOf(sourceTables.build());
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        if (this.function().getReturnType() == Expression.ReturnType.SAME_AS_INPUT) {
            return Expressions.getIntersectionOfAttributes(this.arguments());
        }
        return this.function().getReturnType().getAttributes();
    }

    @Override
    public final boolean isAggregating() {
        return this.function().getFunctionType() == FunctionDefinition.FunctionType.AGGREGATING && !this.window().isPresent();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    public final void check() {
        ContourExceptions.client400PreconditionWithSafeMessage(this.function().getNumArgs() == -1 || this.function().getNumArgs() == this.arguments().size(), String.format("Function '%s' provided with %s arguments, but it should have %s.", this.function().name(), this.arguments().size(), this.function().getNumArgs()), new Arg[0]);
        if (this.function().getFunctionType() == FunctionDefinition.FunctionType.TRANSFORM) {
            ContourExceptions.client400PreconditionWithSafeMessage(!this.window().isPresent(), String.format("Windows may only be specified for aggregate functions. Function '%s' is a transform function.", this.function().name()), new Arg[0]);
        }
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> resolver) {
        String expressions = Joiner.on(", ").join(this.arguments().stream().map(e -> (String)e.accept(resolver)).collect(Collectors.toList()));
        String windowFunctionString = this.window().map(window -> new FunctionWindowRepresentation((FunctionWindow)window, ExpressionStringBuilder.from(resolver))).map(FunctionWindowRepresentation::toString).orElse("");
        return this.function().name() + "(" + expressions + ")" + windowFunctionString;
    }

    @Override
    public String userFriendlyName() {
        return "function";
    }

    public boolean acceptsVarArgs() {
        return this.function().getNumArgs() == -1;
    }

    @Value.Parameter
    public abstract FunctionDefinition function();

    @Value.Parameter
    public abstract List<Expression> arguments();

    @Value.Parameter
    public abstract Optional<FunctionWindow> window();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableFunctionExpression.Builder {
    }
}

