/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Arg;
import java.util.List;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.FrameBy;
import latitude.api.expression.ImmutableFunctionWindow;
import latitude.api.expression.OrderBy;
import latitude.api.expression.PartitionBy;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableFunctionWindow.class)
@JsonSerialize(as=ImmutableFunctionWindow.class)
@Value.Immutable
public abstract class FunctionWindow {
    @Value.Parameter
    public abstract Optional<PartitionBy> partitionBy();

    @Value.Parameter
    public abstract List<OrderBy> orderBys();

    @Value.Parameter
    public abstract Optional<FrameBy> frameBy();

    @Value.Check
    public final void check() {
        if (this.frameBy().isPresent()) {
            if (this.frameBy().get().type() == FrameBy.FrameByType.RANGE) {
                ContourExceptions.client400PreconditionWithSafeMessage(this.orderBys().size() == 1, "When using a range frame, exactly 1 order by column must be specified.", new Arg[0]);
            }
            ContourExceptions.client400PreconditionWithSafeMessage(!this.orderBys().isEmpty(), "Window frame cannot be specified without an ORDER BY.", new Arg[0]);
        }
    }

    public static FunctionWindow of(Optional<PartitionBy> partitionBy, List<OrderBy> orderBys, Optional<FrameBy> frameBy) {
        return ImmutableFunctionWindow.of(partitionBy, orderBys, frameBy);
    }

    public static FunctionWindow empty() {
        return ImmutableFunctionWindow.of(Optional.empty(), ImmutableList.of(), Optional.empty());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableFunctionWindow.Builder {
    }
}

