/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.expression.BinaryExpression;
import latitude.api.expression.Expression;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BinaryExpression", generator="Immutables")
@Immutable
public final class ImmutableBinaryExpression
extends BinaryExpression {
    private final Expression left;
    private final BinaryExpression.BinaryOperation operation;
    private final Expression right;

    private ImmutableBinaryExpression(Expression left, BinaryExpression.BinaryOperation operation, Expression right) {
        this.left = Objects.requireNonNull(left, "left");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.right = Objects.requireNonNull(right, "right");
    }

    private ImmutableBinaryExpression(ImmutableBinaryExpression original, Expression left, BinaryExpression.BinaryOperation operation, Expression right) {
        this.left = left;
        this.operation = operation;
        this.right = right;
    }

    @Override
    @JsonProperty(value="left")
    public Expression left() {
        return this.left;
    }

    @Override
    @JsonProperty(value="operation")
    public BinaryExpression.BinaryOperation operation() {
        return this.operation;
    }

    @Override
    @JsonProperty(value="right")
    public Expression right() {
        return this.right;
    }

    public final ImmutableBinaryExpression withLeft(Expression value) {
        if (this.left == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "left");
        return new ImmutableBinaryExpression(this, newValue, this.operation, this.right);
    }

    public final ImmutableBinaryExpression withOperation(BinaryExpression.BinaryOperation value) {
        BinaryExpression.BinaryOperation newValue = Objects.requireNonNull(value, "operation");
        if (this.operation == newValue) {
            return this;
        }
        return new ImmutableBinaryExpression(this, this.left, newValue, this.right);
    }

    public final ImmutableBinaryExpression withRight(Expression value) {
        if (this.right == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "right");
        return new ImmutableBinaryExpression(this, this.left, this.operation, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBinaryExpression && this.equalTo(0, (ImmutableBinaryExpression)another);
    }

    private boolean equalTo(int synthetic, ImmutableBinaryExpression another) {
        return this.left.equals(another.left) && this.operation.equals((Object)another.operation) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("BinaryExpression").omitNullValues().add("left", this.left).add("operation", (Object)this.operation).add("right", this.right).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBinaryExpression fromJson(Json json) {
        BinaryExpression.Builder builder = new BinaryExpression.Builder();
        if (json.left != null) {
            builder.left(json.left);
        }
        if (json.operation != null) {
            builder.operation(json.operation);
        }
        if (json.right != null) {
            builder.right(json.right);
        }
        return builder.build();
    }

    public static ImmutableBinaryExpression of(Expression left, BinaryExpression.BinaryOperation operation, Expression right) {
        return new ImmutableBinaryExpression(left, operation, right);
    }

    public static ImmutableBinaryExpression copyOf(BinaryExpression instance) {
        if (instance instanceof ImmutableBinaryExpression) {
            return (ImmutableBinaryExpression)instance;
        }
        return new BinaryExpression.Builder().from(instance).build();
    }

    @Generated(from="BinaryExpression", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_OPERATION = 2L;
        private static final long INIT_BIT_RIGHT = 4L;
        private long initBits = 7L;
        @Nullable
        private Expression left;
        @Nullable
        private BinaryExpression.BinaryOperation operation;
        @Nullable
        private Expression right;

        public Builder() {
            if (!(this instanceof BinaryExpression.Builder)) {
                throw new UnsupportedOperationException("Use: new BinaryExpression.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final BinaryExpression.Builder from(BinaryExpression instance) {
            Objects.requireNonNull(instance, "instance");
            this.left(instance.left());
            this.operation(instance.operation());
            this.right(instance.right());
            return (BinaryExpression.Builder)this;
        }

        @JsonProperty(value="left")
        @CanIgnoreReturnValue
        public final BinaryExpression.Builder left(Expression left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (BinaryExpression.Builder)this;
        }

        @JsonProperty(value="operation")
        @CanIgnoreReturnValue
        public final BinaryExpression.Builder operation(BinaryExpression.BinaryOperation operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (BinaryExpression.Builder)this;
        }

        @JsonProperty(value="right")
        @CanIgnoreReturnValue
        public final BinaryExpression.Builder right(Expression right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (BinaryExpression.Builder)this;
        }

        public ImmutableBinaryExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBinaryExpression(null, this.left, this.operation, this.right);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("right");
            }
            return "Cannot build BinaryExpression, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BinaryExpression", generator="Immutables")
    static final class Json
    extends BinaryExpression {
        @Nullable
        Expression left;
        @Nullable
        BinaryExpression.BinaryOperation operation;
        @Nullable
        Expression right;

        Json() {
        }

        @JsonProperty(value="left")
        public void setLeft(Expression left) {
            this.left = left;
        }

        @JsonProperty(value="operation")
        public void setOperation(BinaryExpression.BinaryOperation operation) {
            this.operation = operation;
        }

        @JsonProperty(value="right")
        public void setRight(Expression right) {
            this.right = right;
        }

        @Override
        public Expression left() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinaryExpression.BinaryOperation operation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Expression right() {
            throw new UnsupportedOperationException();
        }
    }
}

