/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.expression.CaseExpression;
import latitude.api.expression.Expression;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CaseExpression", generator="Immutables")
@Immutable
public final class ImmutableCaseExpression
extends CaseExpression {
    @Nullable
    private final Expression base;
    private final ImmutableList<Expression> whens;
    private final ImmutableList<Expression> thens;
    @Nullable
    private final Expression elze;

    private ImmutableCaseExpression(Optional<? extends Expression> base, Iterable<? extends Expression> whens, Iterable<? extends Expression> thens, Optional<? extends Expression> elze) {
        this.base = base.orElse(null);
        this.whens = ImmutableList.copyOf(whens);
        this.thens = ImmutableList.copyOf(thens);
        this.elze = elze.orElse(null);
    }

    private ImmutableCaseExpression(ImmutableCaseExpression original, @Nullable Expression base, ImmutableList<Expression> whens, ImmutableList<Expression> thens, @Nullable Expression elze) {
        this.base = base;
        this.whens = whens;
        this.thens = thens;
        this.elze = elze;
    }

    @Override
    @JsonProperty(value="base")
    public Optional<Expression> base() {
        return Optional.ofNullable(this.base);
    }

    @JsonProperty(value="whens")
    public ImmutableList<Expression> whens() {
        return this.whens;
    }

    @JsonProperty(value="thens")
    public ImmutableList<Expression> thens() {
        return this.thens;
    }

    @Override
    @JsonProperty(value="elze")
    public Optional<Expression> elze() {
        return Optional.ofNullable(this.elze);
    }

    public final ImmutableCaseExpression withBase(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "base");
        if (this.base == newValue) {
            return this;
        }
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, newValue, this.whens, this.thens, this.elze));
    }

    public final ImmutableCaseExpression withBase(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.base == value) {
            return this;
        }
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, value, this.whens, this.thens, this.elze));
    }

    public final ImmutableCaseExpression withWhens(Expression ... elements) {
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, newValue, this.thens, this.elze));
    }

    public final ImmutableCaseExpression withWhens(Iterable<? extends Expression> elements) {
        if (this.whens == elements) {
            return this;
        }
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, newValue, this.thens, this.elze));
    }

    public final ImmutableCaseExpression withThens(Expression ... elements) {
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, this.whens, newValue, this.elze));
    }

    public final ImmutableCaseExpression withThens(Iterable<? extends Expression> elements) {
        if (this.thens == elements) {
            return this;
        }
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, this.whens, newValue, this.elze));
    }

    public final ImmutableCaseExpression withElze(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "elze");
        if (this.elze == newValue) {
            return this;
        }
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, this.whens, this.thens, newValue));
    }

    public final ImmutableCaseExpression withElze(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.elze == value) {
            return this;
        }
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(this, this.base, this.whens, this.thens, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCaseExpression && this.equalTo(0, (ImmutableCaseExpression)another);
    }

    private boolean equalTo(int synthetic, ImmutableCaseExpression another) {
        return Objects.equals(this.base, another.base) && this.whens.equals(another.whens) && this.thens.equals(another.thens) && Objects.equals(this.elze, another.elze);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.base);
        h += (h << 5) + this.whens.hashCode();
        h += (h << 5) + this.thens.hashCode();
        h += (h << 5) + Objects.hashCode(this.elze);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CaseExpression").omitNullValues().add("base", this.base).add("whens", this.whens).add("thens", this.thens).add("elze", this.elze).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCaseExpression fromJson(Json json) {
        CaseExpression.Builder builder = new CaseExpression.Builder();
        if (json.base != null) {
            builder.base(json.base);
        }
        if (json.whens != null) {
            builder.addAllWhens(json.whens);
        }
        if (json.thens != null) {
            builder.addAllThens(json.thens);
        }
        if (json.elze != null) {
            builder.elze(json.elze);
        }
        return builder.build();
    }

    public static ImmutableCaseExpression of(Optional<Expression> base, List<Expression> whens, List<Expression> thens, Optional<Expression> elze) {
        return ImmutableCaseExpression.of(base, whens, thens, elze);
    }

    public static ImmutableCaseExpression of(Optional<? extends Expression> base, Iterable<? extends Expression> whens, Iterable<? extends Expression> thens, Optional<? extends Expression> elze) {
        return ImmutableCaseExpression.validate(new ImmutableCaseExpression(base, whens, thens, elze));
    }

    private static ImmutableCaseExpression validate(ImmutableCaseExpression instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCaseExpression copyOf(CaseExpression instance) {
        if (instance instanceof ImmutableCaseExpression) {
            return (ImmutableCaseExpression)instance;
        }
        return new CaseExpression.Builder().from(instance).build();
    }

    @Generated(from="CaseExpression", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        @Nullable
        private Expression base;
        private ImmutableList.Builder<Expression> whens = ImmutableList.builder();
        private ImmutableList.Builder<Expression> thens = ImmutableList.builder();
        @Nullable
        private Expression elze;

        public Builder() {
            if (!(this instanceof CaseExpression.Builder)) {
                throw new UnsupportedOperationException("Use: new CaseExpression.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder from(CaseExpression instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Expression> baseOptional = instance.base();
            if (baseOptional.isPresent()) {
                this.base(baseOptional);
            }
            this.addAllWhens(instance.whens());
            this.addAllThens(instance.thens());
            Optional<Expression> elzeOptional = instance.elze();
            if (elzeOptional.isPresent()) {
                this.elze(elzeOptional);
            }
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder base(Expression base) {
            this.base = Objects.requireNonNull(base, "base");
            return (CaseExpression.Builder)this;
        }

        @JsonProperty(value="base")
        @CanIgnoreReturnValue
        public final CaseExpression.Builder base(Optional<? extends Expression> base) {
            this.base = base.orElse(null);
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addWhens(Expression element) {
            this.whens.add((Object)element);
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addWhens(Expression ... elements) {
            this.whens.add(elements);
            return (CaseExpression.Builder)this;
        }

        @JsonProperty(value="whens")
        @CanIgnoreReturnValue
        public final CaseExpression.Builder whens(Iterable<? extends Expression> elements) {
            this.whens = ImmutableList.builder();
            return this.addAllWhens(elements);
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addAllWhens(Iterable<? extends Expression> elements) {
            this.whens.addAll(elements);
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addThens(Expression element) {
            this.thens.add((Object)element);
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addThens(Expression ... elements) {
            this.thens.add(elements);
            return (CaseExpression.Builder)this;
        }

        @JsonProperty(value="thens")
        @CanIgnoreReturnValue
        public final CaseExpression.Builder thens(Iterable<? extends Expression> elements) {
            this.thens = ImmutableList.builder();
            return this.addAllThens(elements);
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder addAllThens(Iterable<? extends Expression> elements) {
            this.thens.addAll(elements);
            return (CaseExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CaseExpression.Builder elze(Expression elze) {
            this.elze = Objects.requireNonNull(elze, "elze");
            return (CaseExpression.Builder)this;
        }

        @JsonProperty(value="elze")
        @CanIgnoreReturnValue
        public final CaseExpression.Builder elze(Optional<? extends Expression> elze) {
            this.elze = elze.orElse(null);
            return (CaseExpression.Builder)this;
        }

        public ImmutableCaseExpression build() {
            return ImmutableCaseExpression.validate(new ImmutableCaseExpression(null, this.base, (ImmutableList<Expression>)this.whens.build(), (ImmutableList<Expression>)this.thens.build(), this.elze));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CaseExpression", generator="Immutables")
    static final class Json
    extends CaseExpression {
        @Nullable
        Optional<Expression> base = Optional.empty();
        @Nullable
        List<Expression> whens = ImmutableList.of();
        @Nullable
        List<Expression> thens = ImmutableList.of();
        @Nullable
        Optional<Expression> elze = Optional.empty();

        Json() {
        }

        @JsonProperty(value="base")
        public void setBase(Optional<Expression> base) {
            this.base = base;
        }

        @JsonProperty(value="whens")
        public void setWhens(List<Expression> whens) {
            this.whens = whens;
        }

        @JsonProperty(value="thens")
        public void setThens(List<Expression> thens) {
            this.thens = thens;
        }

        @JsonProperty(value="elze")
        public void setElze(Optional<Expression> elze) {
            this.elze = elze;
        }

        @Override
        public Optional<Expression> base() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Expression> whens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Expression> thens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Expression> elze() {
            throw new UnsupportedOperationException();
        }
    }
}

