/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.expression.Frame;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Frame", generator="Immutables")
@Immutable
public final class ImmutableFrame
extends Frame {
    @Nullable
    private final Parameter<Long> range;
    private final Frame.FrameType type;

    private ImmutableFrame(Optional<? extends Parameter<Long>> range, Frame.FrameType type) {
        this.range = range.orElse(null);
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableFrame(ImmutableFrame original, @Nullable Parameter<Long> range, Frame.FrameType type) {
        this.range = range;
        this.type = type;
    }

    @Override
    @JsonProperty(value="range")
    public Optional<Parameter<Long>> range() {
        return Optional.ofNullable(this.range);
    }

    @Override
    @JsonProperty(value="type")
    public Frame.FrameType type() {
        return this.type;
    }

    public final ImmutableFrame withRange(Parameter<Long> value) {
        Parameter<Long> newValue = Objects.requireNonNull(value, "range");
        if (this.range == newValue) {
            return this;
        }
        return ImmutableFrame.validate(new ImmutableFrame(this, newValue, this.type));
    }

    public final ImmutableFrame withRange(Optional<? extends Parameter<Long>> optional) {
        Parameter value = optional.orElse(null);
        if (this.range == value) {
            return this;
        }
        return ImmutableFrame.validate(new ImmutableFrame(this, value, this.type));
    }

    public final ImmutableFrame withType(Frame.FrameType value) {
        Frame.FrameType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return ImmutableFrame.validate(new ImmutableFrame(this, this.range, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFrame && this.equalTo(0, (ImmutableFrame)another);
    }

    private boolean equalTo(int synthetic, ImmutableFrame another) {
        return Objects.equals(this.range, another.range) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.range);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Frame").omitNullValues().add("range", this.range).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFrame fromJson(Json json) {
        Frame.Builder builder = new Frame.Builder();
        if (json.range != null) {
            builder.range(json.range);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableFrame of(Optional<? extends Parameter<Long>> range, Frame.FrameType type) {
        return ImmutableFrame.validate(new ImmutableFrame(range, type));
    }

    private static ImmutableFrame validate(ImmutableFrame instance) {
        instance.check();
        return instance;
    }

    public static ImmutableFrame copyOf(Frame instance) {
        if (instance instanceof ImmutableFrame) {
            return (ImmutableFrame)instance;
        }
        return new Frame.Builder().from(instance).build();
    }

    @Generated(from="Frame", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Parameter<Long> range;
        @Nullable
        private Frame.FrameType type;

        public Builder() {
            if (!(this instanceof Frame.Builder)) {
                throw new UnsupportedOperationException("Use: new Frame.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final Frame.Builder from(Frame instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Parameter<Long>> rangeOptional = instance.range();
            if (rangeOptional.isPresent()) {
                this.range(rangeOptional);
            }
            this.type(instance.type());
            return (Frame.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Frame.Builder range(Parameter<Long> range) {
            this.range = Objects.requireNonNull(range, "range");
            return (Frame.Builder)this;
        }

        @JsonProperty(value="range")
        @CanIgnoreReturnValue
        public final Frame.Builder range(Optional<? extends Parameter<Long>> range) {
            this.range = range.orElse(null);
            return (Frame.Builder)this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Frame.Builder type(Frame.FrameType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Frame.Builder)this;
        }

        public ImmutableFrame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFrame.validate(new ImmutableFrame(null, this.range, this.type));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Frame, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Frame", generator="Immutables")
    static final class Json
    extends Frame {
        @Nullable
        Optional<Parameter<Long>> range = Optional.empty();
        @Nullable
        Frame.FrameType type;

        Json() {
        }

        @JsonProperty(value="range")
        public void setRange(Optional<Parameter<Long>> range) {
            this.range = range;
        }

        @JsonProperty(value="type")
        public void setType(Frame.FrameType type) {
            this.type = type;
        }

        @Override
        public Optional<Parameter<Long>> range() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Frame.FrameType type() {
            throw new UnsupportedOperationException();
        }
    }
}

