/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.expression.Expression;
import latitude.api.expression.FunctionDefinition;
import latitude.api.expression.FunctionExpression;
import latitude.api.expression.FunctionWindow;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FunctionExpression", generator="Immutables")
@Immutable
public final class ImmutableFunctionExpression
extends FunctionExpression {
    private final FunctionDefinition function;
    private final ImmutableList<Expression> arguments;
    @Nullable
    private final FunctionWindow window;

    private ImmutableFunctionExpression(FunctionDefinition function, Iterable<? extends Expression> arguments, Optional<? extends FunctionWindow> window) {
        this.function = Objects.requireNonNull(function, "function");
        this.arguments = ImmutableList.copyOf(arguments);
        this.window = window.orElse(null);
    }

    private ImmutableFunctionExpression(ImmutableFunctionExpression original, FunctionDefinition function, ImmutableList<Expression> arguments, @Nullable FunctionWindow window) {
        this.function = function;
        this.arguments = arguments;
        this.window = window;
    }

    @Override
    @JsonProperty(value="function")
    public FunctionDefinition function() {
        return this.function;
    }

    @JsonProperty(value="arguments")
    public ImmutableList<Expression> arguments() {
        return this.arguments;
    }

    @Override
    @JsonProperty(value="window")
    public Optional<FunctionWindow> window() {
        return Optional.ofNullable(this.window);
    }

    public final ImmutableFunctionExpression withFunction(FunctionDefinition value) {
        FunctionDefinition newValue = Objects.requireNonNull(value, "function");
        if (this.function == newValue) {
            return this;
        }
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(this, newValue, this.arguments, this.window));
    }

    public final ImmutableFunctionExpression withArguments(Expression ... elements) {
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(this, this.function, newValue, this.window));
    }

    public final ImmutableFunctionExpression withArguments(Iterable<? extends Expression> elements) {
        if (this.arguments == elements) {
            return this;
        }
        ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(this, this.function, newValue, this.window));
    }

    public final ImmutableFunctionExpression withWindow(FunctionWindow value) {
        FunctionWindow newValue = Objects.requireNonNull(value, "window");
        if (this.window == newValue) {
            return this;
        }
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(this, this.function, this.arguments, newValue));
    }

    public final ImmutableFunctionExpression withWindow(Optional<? extends FunctionWindow> optional) {
        FunctionWindow value = optional.orElse(null);
        if (this.window == value) {
            return this;
        }
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(this, this.function, this.arguments, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFunctionExpression && this.equalTo(0, (ImmutableFunctionExpression)another);
    }

    private boolean equalTo(int synthetic, ImmutableFunctionExpression another) {
        return this.function.equals((Object)another.function) && this.arguments.equals(another.arguments) && Objects.equals(this.window, another.window);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.function.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + Objects.hashCode(this.window);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FunctionExpression").omitNullValues().add("function", (Object)this.function).add("arguments", this.arguments).add("window", this.window).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFunctionExpression fromJson(Json json) {
        FunctionExpression.Builder builder = new FunctionExpression.Builder();
        if (json.function != null) {
            builder.function(json.function);
        }
        if (json.arguments != null) {
            builder.addAllArguments(json.arguments);
        }
        if (json.window != null) {
            builder.window(json.window);
        }
        return builder.build();
    }

    public static ImmutableFunctionExpression of(FunctionDefinition function, List<Expression> arguments, Optional<FunctionWindow> window) {
        return ImmutableFunctionExpression.of(function, arguments, window);
    }

    public static ImmutableFunctionExpression of(FunctionDefinition function, Iterable<? extends Expression> arguments, Optional<? extends FunctionWindow> window) {
        return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(function, arguments, window));
    }

    private static ImmutableFunctionExpression validate(ImmutableFunctionExpression instance) {
        instance.check();
        return instance;
    }

    public static ImmutableFunctionExpression copyOf(FunctionExpression instance) {
        if (instance instanceof ImmutableFunctionExpression) {
            return (ImmutableFunctionExpression)instance;
        }
        return new FunctionExpression.Builder().from(instance).build();
    }

    @Generated(from="FunctionExpression", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_FUNCTION = 1L;
        private long initBits = 1L;
        @Nullable
        private FunctionDefinition function;
        private ImmutableList.Builder<Expression> arguments = ImmutableList.builder();
        @Nullable
        private FunctionWindow window;

        public Builder() {
            if (!(this instanceof FunctionExpression.Builder)) {
                throw new UnsupportedOperationException("Use: new FunctionExpression.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final FunctionExpression.Builder from(FunctionExpression instance) {
            Objects.requireNonNull(instance, "instance");
            this.function(instance.function());
            this.addAllArguments(instance.arguments());
            Optional<FunctionWindow> windowOptional = instance.window();
            if (windowOptional.isPresent()) {
                this.window(windowOptional);
            }
            return (FunctionExpression.Builder)this;
        }

        @JsonProperty(value="function")
        @CanIgnoreReturnValue
        public final FunctionExpression.Builder function(FunctionDefinition function) {
            this.function = Objects.requireNonNull(function, "function");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (FunctionExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionExpression.Builder addArguments(Expression element) {
            this.arguments.add((Object)element);
            return (FunctionExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionExpression.Builder addArguments(Expression ... elements) {
            this.arguments.add(elements);
            return (FunctionExpression.Builder)this;
        }

        @JsonProperty(value="arguments")
        @CanIgnoreReturnValue
        public final FunctionExpression.Builder arguments(Iterable<? extends Expression> elements) {
            this.arguments = ImmutableList.builder();
            return this.addAllArguments(elements);
        }

        @CanIgnoreReturnValue
        public final FunctionExpression.Builder addAllArguments(Iterable<? extends Expression> elements) {
            this.arguments.addAll(elements);
            return (FunctionExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionExpression.Builder window(FunctionWindow window) {
            this.window = Objects.requireNonNull(window, "window");
            return (FunctionExpression.Builder)this;
        }

        @JsonProperty(value="window")
        @CanIgnoreReturnValue
        public final FunctionExpression.Builder window(Optional<? extends FunctionWindow> window) {
            this.window = window.orElse(null);
            return (FunctionExpression.Builder)this;
        }

        public ImmutableFunctionExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFunctionExpression.validate(new ImmutableFunctionExpression(null, this.function, (ImmutableList<Expression>)this.arguments.build(), this.window));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("function");
            }
            return "Cannot build FunctionExpression, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FunctionExpression", generator="Immutables")
    static final class Json
    extends FunctionExpression {
        @Nullable
        FunctionDefinition function;
        @Nullable
        List<Expression> arguments = ImmutableList.of();
        @Nullable
        Optional<FunctionWindow> window = Optional.empty();

        Json() {
        }

        @JsonProperty(value="function")
        public void setFunction(FunctionDefinition function) {
            this.function = function;
        }

        @JsonProperty(value="arguments")
        public void setArguments(List<Expression> arguments) {
            this.arguments = arguments;
        }

        @JsonProperty(value="window")
        public void setWindow(Optional<FunctionWindow> window) {
            this.window = window;
        }

        @Override
        public FunctionDefinition function() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Expression> arguments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<FunctionWindow> window() {
            throw new UnsupportedOperationException();
        }
    }
}

