/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.expression.FrameBy;
import latitude.api.expression.FunctionWindow;
import latitude.api.expression.OrderBy;
import latitude.api.expression.PartitionBy;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FunctionWindow", generator="Immutables")
@Immutable
public final class ImmutableFunctionWindow
extends FunctionWindow {
    @Nullable
    private final PartitionBy partitionBy;
    private final ImmutableList<OrderBy> orderBys;
    @Nullable
    private final FrameBy frameBy;

    private ImmutableFunctionWindow(Optional<? extends PartitionBy> partitionBy, Iterable<? extends OrderBy> orderBys, Optional<? extends FrameBy> frameBy) {
        this.partitionBy = partitionBy.orElse(null);
        this.orderBys = ImmutableList.copyOf(orderBys);
        this.frameBy = frameBy.orElse(null);
    }

    private ImmutableFunctionWindow(ImmutableFunctionWindow original, @Nullable PartitionBy partitionBy, ImmutableList<OrderBy> orderBys, @Nullable FrameBy frameBy) {
        this.partitionBy = partitionBy;
        this.orderBys = orderBys;
        this.frameBy = frameBy;
    }

    @Override
    @JsonProperty(value="partitionBy")
    public Optional<PartitionBy> partitionBy() {
        return Optional.ofNullable(this.partitionBy);
    }

    @JsonProperty(value="orderBys")
    public ImmutableList<OrderBy> orderBys() {
        return this.orderBys;
    }

    @Override
    @JsonProperty(value="frameBy")
    public Optional<FrameBy> frameBy() {
        return Optional.ofNullable(this.frameBy);
    }

    public final ImmutableFunctionWindow withPartitionBy(PartitionBy value) {
        PartitionBy newValue = Objects.requireNonNull(value, "partitionBy");
        if (this.partitionBy == newValue) {
            return this;
        }
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, newValue, this.orderBys, this.frameBy));
    }

    public final ImmutableFunctionWindow withPartitionBy(Optional<? extends PartitionBy> optional) {
        PartitionBy value = optional.orElse(null);
        if (this.partitionBy == value) {
            return this;
        }
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, value, this.orderBys, this.frameBy));
    }

    public final ImmutableFunctionWindow withOrderBys(OrderBy ... elements) {
        ImmutableList<OrderBy> newValue = ImmutableList.copyOf(elements);
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, this.partitionBy, newValue, this.frameBy));
    }

    public final ImmutableFunctionWindow withOrderBys(Iterable<? extends OrderBy> elements) {
        if (this.orderBys == elements) {
            return this;
        }
        ImmutableList<OrderBy> newValue = ImmutableList.copyOf(elements);
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, this.partitionBy, newValue, this.frameBy));
    }

    public final ImmutableFunctionWindow withFrameBy(FrameBy value) {
        FrameBy newValue = Objects.requireNonNull(value, "frameBy");
        if (this.frameBy == newValue) {
            return this;
        }
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, this.partitionBy, this.orderBys, newValue));
    }

    public final ImmutableFunctionWindow withFrameBy(Optional<? extends FrameBy> optional) {
        FrameBy value = optional.orElse(null);
        if (this.frameBy == value) {
            return this;
        }
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(this, this.partitionBy, this.orderBys, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFunctionWindow && this.equalTo(0, (ImmutableFunctionWindow)another);
    }

    private boolean equalTo(int synthetic, ImmutableFunctionWindow another) {
        return Objects.equals(this.partitionBy, another.partitionBy) && this.orderBys.equals(another.orderBys) && Objects.equals(this.frameBy, another.frameBy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.partitionBy);
        h += (h << 5) + this.orderBys.hashCode();
        h += (h << 5) + Objects.hashCode(this.frameBy);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FunctionWindow").omitNullValues().add("partitionBy", this.partitionBy).add("orderBys", this.orderBys).add("frameBy", this.frameBy).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFunctionWindow fromJson(Json json) {
        FunctionWindow.Builder builder = new FunctionWindow.Builder();
        if (json.partitionBy != null) {
            builder.partitionBy(json.partitionBy);
        }
        if (json.orderBys != null) {
            builder.addAllOrderBys(json.orderBys);
        }
        if (json.frameBy != null) {
            builder.frameBy(json.frameBy);
        }
        return builder.build();
    }

    public static ImmutableFunctionWindow of(Optional<PartitionBy> partitionBy, List<OrderBy> orderBys, Optional<FrameBy> frameBy) {
        return ImmutableFunctionWindow.of(partitionBy, orderBys, frameBy);
    }

    public static ImmutableFunctionWindow of(Optional<? extends PartitionBy> partitionBy, Iterable<? extends OrderBy> orderBys, Optional<? extends FrameBy> frameBy) {
        return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(partitionBy, orderBys, frameBy));
    }

    private static ImmutableFunctionWindow validate(ImmutableFunctionWindow instance) {
        instance.check();
        return instance;
    }

    public static ImmutableFunctionWindow copyOf(FunctionWindow instance) {
        if (instance instanceof ImmutableFunctionWindow) {
            return (ImmutableFunctionWindow)instance;
        }
        return new FunctionWindow.Builder().from(instance).build();
    }

    @Generated(from="FunctionWindow", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        @Nullable
        private PartitionBy partitionBy;
        private ImmutableList.Builder<OrderBy> orderBys = ImmutableList.builder();
        @Nullable
        private FrameBy frameBy;

        public Builder() {
            if (!(this instanceof FunctionWindow.Builder)) {
                throw new UnsupportedOperationException("Use: new FunctionWindow.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder from(FunctionWindow instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<PartitionBy> partitionByOptional = instance.partitionBy();
            if (partitionByOptional.isPresent()) {
                this.partitionBy(partitionByOptional);
            }
            this.addAllOrderBys(instance.orderBys());
            Optional<FrameBy> frameByOptional = instance.frameBy();
            if (frameByOptional.isPresent()) {
                this.frameBy(frameByOptional);
            }
            return (FunctionWindow.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder partitionBy(PartitionBy partitionBy) {
            this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy");
            return (FunctionWindow.Builder)this;
        }

        @JsonProperty(value="partitionBy")
        @CanIgnoreReturnValue
        public final FunctionWindow.Builder partitionBy(Optional<? extends PartitionBy> partitionBy) {
            this.partitionBy = partitionBy.orElse(null);
            return (FunctionWindow.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder addOrderBys(OrderBy element) {
            this.orderBys.add((Object)element);
            return (FunctionWindow.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder addOrderBys(OrderBy ... elements) {
            this.orderBys.add(elements);
            return (FunctionWindow.Builder)this;
        }

        @JsonProperty(value="orderBys")
        @CanIgnoreReturnValue
        public final FunctionWindow.Builder orderBys(Iterable<? extends OrderBy> elements) {
            this.orderBys = ImmutableList.builder();
            return this.addAllOrderBys(elements);
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder addAllOrderBys(Iterable<? extends OrderBy> elements) {
            this.orderBys.addAll(elements);
            return (FunctionWindow.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FunctionWindow.Builder frameBy(FrameBy frameBy) {
            this.frameBy = Objects.requireNonNull(frameBy, "frameBy");
            return (FunctionWindow.Builder)this;
        }

        @JsonProperty(value="frameBy")
        @CanIgnoreReturnValue
        public final FunctionWindow.Builder frameBy(Optional<? extends FrameBy> frameBy) {
            this.frameBy = frameBy.orElse(null);
            return (FunctionWindow.Builder)this;
        }

        public ImmutableFunctionWindow build() {
            return ImmutableFunctionWindow.validate(new ImmutableFunctionWindow(null, this.partitionBy, (ImmutableList<OrderBy>)this.orderBys.build(), this.frameBy));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FunctionWindow", generator="Immutables")
    static final class Json
    extends FunctionWindow {
        @Nullable
        Optional<PartitionBy> partitionBy = Optional.empty();
        @Nullable
        List<OrderBy> orderBys = ImmutableList.of();
        @Nullable
        Optional<FrameBy> frameBy = Optional.empty();

        Json() {
        }

        @JsonProperty(value="partitionBy")
        public void setPartitionBy(Optional<PartitionBy> partitionBy) {
            this.partitionBy = partitionBy;
        }

        @JsonProperty(value="orderBys")
        public void setOrderBys(List<OrderBy> orderBys) {
            this.orderBys = orderBys;
        }

        @JsonProperty(value="frameBy")
        public void setFrameBy(Optional<FrameBy> frameBy) {
            this.frameBy = frameBy;
        }

        @Override
        public Optional<PartitionBy> partitionBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OrderBy> orderBys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<FrameBy> frameBy() {
            throw new UnsupportedOperationException();
        }
    }
}

