/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import latitude.api.expression.Expression;
import latitude.api.expression.InExpression;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InExpression", generator="Immutables")
@Immutable
public final class ImmutableInExpression
extends InExpression {
    private final Expression expression;
    private final boolean not;
    private final ImmutableList<Parameter<Object>> objectsToCompare;

    private ImmutableInExpression(Expression expression, boolean not, Iterable<? extends Parameter<Object>> objectsToCompare) {
        this.expression = Objects.requireNonNull(expression, "expression");
        this.not = not;
        this.objectsToCompare = ImmutableList.copyOf(objectsToCompare);
    }

    private ImmutableInExpression(ImmutableInExpression original, Expression expression, boolean not, ImmutableList<Parameter<Object>> objectsToCompare) {
        this.expression = expression;
        this.not = not;
        this.objectsToCompare = objectsToCompare;
    }

    @Override
    @JsonProperty(value="expression")
    public Expression expression() {
        return this.expression;
    }

    @Override
    @JsonProperty(value="not")
    public boolean not() {
        return this.not;
    }

    @JsonProperty(value="objectsToCompare")
    public ImmutableList<Parameter<Object>> objectsToCompare() {
        return this.objectsToCompare;
    }

    public final ImmutableInExpression withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableInExpression(this, newValue, this.not, this.objectsToCompare);
    }

    public final ImmutableInExpression withNot(boolean value) {
        if (this.not == value) {
            return this;
        }
        return new ImmutableInExpression(this, this.expression, value, this.objectsToCompare);
    }

    @SafeVarargs
    public final ImmutableInExpression withObjectsToCompare(Parameter<Object> ... elements) {
        ImmutableList<Parameter<Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInExpression(this, this.expression, this.not, newValue);
    }

    public final ImmutableInExpression withObjectsToCompare(Iterable<? extends Parameter<Object>> elements) {
        if (this.objectsToCompare == elements) {
            return this;
        }
        ImmutableList<Parameter<Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInExpression(this, this.expression, this.not, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInExpression && this.equalTo(0, (ImmutableInExpression)another);
    }

    private boolean equalTo(int synthetic, ImmutableInExpression another) {
        return this.expression.equals(another.expression) && this.not == another.not && this.objectsToCompare.equals(another.objectsToCompare);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expression.hashCode();
        h += (h << 5) + Booleans.hashCode(this.not);
        h += (h << 5) + this.objectsToCompare.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InExpression").omitNullValues().add("expression", this.expression).add("not", this.not).add("objectsToCompare", this.objectsToCompare).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInExpression fromJson(Json json) {
        InExpression.Builder builder = new InExpression.Builder();
        if (json.expression != null) {
            builder.expression(json.expression);
        }
        if (json.notIsSet) {
            builder.not(json.not);
        }
        if (json.objectsToCompare != null) {
            builder.addAllObjectsToCompare(json.objectsToCompare);
        }
        return builder.build();
    }

    public static ImmutableInExpression of(Expression expression, boolean not, List<Parameter<Object>> objectsToCompare) {
        return ImmutableInExpression.of(expression, not, objectsToCompare);
    }

    public static ImmutableInExpression of(Expression expression, boolean not, Iterable<? extends Parameter<Object>> objectsToCompare) {
        return new ImmutableInExpression(expression, not, objectsToCompare);
    }

    public static ImmutableInExpression copyOf(InExpression instance) {
        if (instance instanceof ImmutableInExpression) {
            return (ImmutableInExpression)instance;
        }
        return new InExpression.Builder().from(instance).build();
    }

    @Generated(from="InExpression", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private static final long INIT_BIT_NOT = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression expression;
        private boolean not;
        private ImmutableList.Builder<Parameter<Object>> objectsToCompare = ImmutableList.builder();

        public Builder() {
            if (!(this instanceof InExpression.Builder)) {
                throw new UnsupportedOperationException("Use: new InExpression.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final InExpression.Builder from(InExpression instance) {
            Objects.requireNonNull(instance, "instance");
            this.expression(instance.expression());
            this.not(instance.not());
            this.addAllObjectsToCompare(instance.objectsToCompare());
            return (InExpression.Builder)this;
        }

        @JsonProperty(value="expression")
        @CanIgnoreReturnValue
        public final InExpression.Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (InExpression.Builder)this;
        }

        @JsonProperty(value="not")
        @CanIgnoreReturnValue
        public final InExpression.Builder not(boolean not) {
            this.not = not;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (InExpression.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InExpression.Builder addObjectsToCompare(Parameter<Object> element) {
            this.objectsToCompare.add((Object)element);
            return (InExpression.Builder)this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final InExpression.Builder addObjectsToCompare(Parameter<Object> ... elements) {
            this.objectsToCompare.add(elements);
            return (InExpression.Builder)this;
        }

        @JsonProperty(value="objectsToCompare")
        @CanIgnoreReturnValue
        public final InExpression.Builder objectsToCompare(Iterable<? extends Parameter<Object>> elements) {
            this.objectsToCompare = ImmutableList.builder();
            return this.addAllObjectsToCompare(elements);
        }

        @CanIgnoreReturnValue
        public final InExpression.Builder addAllObjectsToCompare(Iterable<? extends Parameter<Object>> elements) {
            this.objectsToCompare.addAll(elements);
            return (InExpression.Builder)this;
        }

        public ImmutableInExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInExpression(null, this.expression, this.not, (ImmutableList<Parameter<Object>>)this.objectsToCompare.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expression");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("not");
            }
            return "Cannot build InExpression, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InExpression", generator="Immutables")
    static final class Json
    extends InExpression {
        @Nullable
        Expression expression;
        boolean not;
        boolean notIsSet;
        @Nullable
        List<Parameter<Object>> objectsToCompare = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="expression")
        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        @JsonProperty(value="not")
        public void setNot(boolean not) {
            this.not = not;
            this.notIsSet = true;
        }

        @JsonProperty(value="objectsToCompare")
        public void setObjectsToCompare(List<Parameter<Object>> objectsToCompare) {
            this.objectsToCompare = objectsToCompare;
        }

        @Override
        public Expression expression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean not() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Parameter<Object>> objectsToCompare() {
            throw new UnsupportedOperationException();
        }
    }
}

