/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.expression.Expression;
import latitude.api.expression.OrderBy;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OrderBy", generator="Immutables")
@Immutable
public final class ImmutableOrderBy
extends OrderBy {
    private final Expression column;
    private final OrderBy.Order order;
    @Nullable
    private final OrderBy.NullsOrder nullsOrder;

    private ImmutableOrderBy(Expression column, OrderBy.Order order) {
        this.column = Objects.requireNonNull(column, "column");
        this.order = Objects.requireNonNull(order, "order");
        this.nullsOrder = null;
    }

    private ImmutableOrderBy(Expression column, OrderBy.Order order, @Nullable OrderBy.NullsOrder nullsOrder) {
        this.column = column;
        this.order = order;
        this.nullsOrder = nullsOrder;
    }

    @Override
    @JsonProperty(value="column")
    public Expression column() {
        return this.column;
    }

    @Override
    @JsonProperty(value="order")
    public OrderBy.Order order() {
        return this.order;
    }

    @Override
    @JsonProperty(value="nullsOrder")
    public Optional<OrderBy.NullsOrder> nullsOrder() {
        return Optional.ofNullable(this.nullsOrder);
    }

    public final ImmutableOrderBy withColumn(Expression value) {
        if (this.column == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "column");
        return new ImmutableOrderBy(newValue, this.order, this.nullsOrder);
    }

    public final ImmutableOrderBy withOrder(OrderBy.Order value) {
        OrderBy.Order newValue = Objects.requireNonNull(value, "order");
        if (this.order == newValue) {
            return this;
        }
        return new ImmutableOrderBy(this.column, newValue, this.nullsOrder);
    }

    public final ImmutableOrderBy withNullsOrder(OrderBy.NullsOrder value) {
        OrderBy.NullsOrder newValue = Objects.requireNonNull(value, "nullsOrder");
        if (this.nullsOrder == newValue) {
            return this;
        }
        return new ImmutableOrderBy(this.column, this.order, newValue);
    }

    public final ImmutableOrderBy withNullsOrder(Optional<? extends OrderBy.NullsOrder> optional) {
        OrderBy.NullsOrder value = optional.orElse(null);
        if (this.nullsOrder == value) {
            return this;
        }
        return new ImmutableOrderBy(this.column, this.order, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrderBy && this.equalTo(0, (ImmutableOrderBy)another);
    }

    private boolean equalTo(int synthetic, ImmutableOrderBy another) {
        return this.column.equals(another.column) && this.order.equals((Object)another.order) && Objects.equals((Object)this.nullsOrder, (Object)another.nullsOrder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.column.hashCode();
        h += (h << 5) + this.order.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.nullsOrder);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OrderBy").omitNullValues().add("column", this.column).add("order", (Object)this.order).add("nullsOrder", (Object)this.nullsOrder).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOrderBy fromJson(Json json) {
        OrderBy.Builder builder = new OrderBy.Builder();
        if (json.column != null) {
            builder.column(json.column);
        }
        if (json.order != null) {
            builder.order(json.order);
        }
        if (json.nullsOrder != null) {
            builder.nullsOrder(json.nullsOrder);
        }
        return builder.build();
    }

    public static ImmutableOrderBy of(Expression column, OrderBy.Order order) {
        return new ImmutableOrderBy(column, order);
    }

    public static ImmutableOrderBy copyOf(OrderBy instance) {
        if (instance instanceof ImmutableOrderBy) {
            return (ImmutableOrderBy)instance;
        }
        return new OrderBy.Builder().from(instance).build();
    }

    @Generated(from="OrderBy", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_COLUMN = 1L;
        private static final long INIT_BIT_ORDER = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression column;
        @Nullable
        private OrderBy.Order order;
        @Nullable
        private OrderBy.NullsOrder nullsOrder;

        public Builder() {
            if (!(this instanceof OrderBy.Builder)) {
                throw new UnsupportedOperationException("Use: new OrderBy.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final OrderBy.Builder from(OrderBy instance) {
            Objects.requireNonNull(instance, "instance");
            this.column(instance.column());
            this.order(instance.order());
            Optional<OrderBy.NullsOrder> nullsOrderOptional = instance.nullsOrder();
            if (nullsOrderOptional.isPresent()) {
                this.nullsOrder(nullsOrderOptional);
            }
            return (OrderBy.Builder)this;
        }

        @JsonProperty(value="column")
        @CanIgnoreReturnValue
        public final OrderBy.Builder column(Expression column) {
            this.column = Objects.requireNonNull(column, "column");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (OrderBy.Builder)this;
        }

        @JsonProperty(value="order")
        @CanIgnoreReturnValue
        public final OrderBy.Builder order(OrderBy.Order order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (OrderBy.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderBy.Builder nullsOrder(OrderBy.NullsOrder nullsOrder) {
            this.nullsOrder = Objects.requireNonNull(nullsOrder, "nullsOrder");
            return (OrderBy.Builder)this;
        }

        @JsonProperty(value="nullsOrder")
        @CanIgnoreReturnValue
        public final OrderBy.Builder nullsOrder(Optional<? extends OrderBy.NullsOrder> nullsOrder) {
            this.nullsOrder = nullsOrder.orElse(null);
            return (OrderBy.Builder)this;
        }

        public ImmutableOrderBy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOrderBy(this.column, this.order, this.nullsOrder);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("column");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("order");
            }
            return "Cannot build OrderBy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OrderBy", generator="Immutables")
    static final class Json
    extends OrderBy {
        @Nullable
        Expression column;
        @Nullable
        OrderBy.Order order;
        @Nullable
        Optional<OrderBy.NullsOrder> nullsOrder = Optional.empty();

        Json() {
        }

        @JsonProperty(value="column")
        public void setColumn(Expression column) {
            this.column = column;
        }

        @JsonProperty(value="order")
        public void setOrder(OrderBy.Order order) {
            this.order = order;
        }

        @JsonProperty(value="nullsOrder")
        public void setNullsOrder(Optional<OrderBy.NullsOrder> nullsOrder) {
            this.nullsOrder = nullsOrder;
        }

        @Override
        public Expression column() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OrderBy.Order order() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OrderBy.NullsOrder> nullsOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

