/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableInExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.ParameterLiteral;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.base.Joiner;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableInExpression.class)
@JsonSerialize(as=ImmutableInExpression.class)
@Value.Immutable
public abstract class InExpression
extends Expression {
    public static InExpression of(Expression expression, boolean not, List<Parameter<Object>> objectsToCompare) {
        return ImmutableInExpression.of(expression, not, objectsToCompare);
    }

    @Override
    public final List<String> getSourceTables() {
        return this.expression().getSourceTables();
    }

    @Override
    public final boolean isAggregating() {
        return this.expression().isAggregating();
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return Expression.ReturnType.BOOLEAN.getAttributes();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        StringBuilder values = new StringBuilder("(");
        values.append(Joiner.on(", ").join(this.objectsToCompare().stream().map(param -> ParameterLiteral.of(param).getExpressionStringRepresentation(expressionResolver)).collect(Collectors.toList())));
        values.append(")");
        String operator = this.not() ? " NOT IN " : " IN ";
        return "(" + this.expression().accept(expressionResolver) + operator + values.toString() + ")";
    }

    @Override
    public String userFriendlyName() {
        return "IN expression";
    }

    @Value.Parameter
    public abstract Expression expression();

    @Value.Parameter
    public abstract boolean not();

    @Value.Parameter
    public abstract List<Parameter<Object>> objectsToCompare();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableInExpression.Builder {
    }
}

