/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Unsafe;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableIntegerLiteral;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.Literal;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableIntegerLiteral.class)
@JsonSerialize(as=ImmutableIntegerLiteral.class)
@Value.Immutable
public abstract class IntegerLiteral
extends Literal {
    public static IntegerLiteral of(long value) {
        return ImmutableIntegerLiteral.of(value);
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return Expression.ReturnType.INTEGER.getAttributes();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> _expressionResolver) {
        return Long.toString(this.value());
    }

    @Override
    public String userFriendlyName() {
        return "integer literal";
    }

    @Value.Parameter
    public abstract long value();

    @Value.Check
    protected final void check() {
        SafeLong.of(this.value());
    }
}

