/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.Locale;
import java.util.Optional;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableOrderBy;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableOrderBy.class)
@JsonSerialize(as=ImmutableOrderBy.class)
@Value.Immutable
public abstract class OrderBy {
    @Value.Parameter
    public abstract Expression column();

    @Value.Parameter
    public abstract Order order();

    public abstract Optional<NullsOrder> nullsOrder();

    public static OrderBy of(Expression column, Order order) {
        return ImmutableOrderBy.of(column, order);
    }

    public static OrderBy of(Expression column, Order order, NullsOrder nullsOrder) {
        return ImmutableOrderBy.builder().column(column).order(order).nullsOrder(nullsOrder).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableOrderBy.Builder {
    }

    public static enum NullsOrder {
        NULLS_FIRST,
        NULLS_LAST;


        public static NullsOrder parse(String nullsOrder) {
            return NullsOrder.valueOf(nullsOrder.replace(" ", "_").toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().replace("_", " ");
        }
    }

    public static enum Order {
        ASC,
        DESC;


        public static Order parse(String order) {
            return Order.valueOf(order.toUpperCase(Locale.ROOT));
        }
    }
}

