/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.column.ColumnInfo;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.ImmutableParameterLiteral;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.Literal;
import latitude.api.expression.StringLiteral;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableParameterLiteral.class)
@JsonSerialize(as=ImmutableParameterLiteral.class)
@Value.Immutable
public abstract class ParameterLiteral
extends Literal {
    public static final String PREFIX_SYMBOL = "$";

    public static ParameterLiteral of(Parameter<?> value) {
        return ImmutableParameterLiteral.of(value);
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return ImmutableSet.of();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Unsafe
    public final String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        if (this.value().getParameterId().isPresent()) {
            return PREFIX_SYMBOL + this.value().getParameterId().get().getId().toString();
        }
        if (this.value().isConcrete()) {
            return this.getStringRepresentationForConcreteValue(this.value().asConcreteValue(), expressionResolver);
        }
        throw ContourExceptions.server500("Attempted to write out a parameter literal but it does not have an id nor a concrete value. This should never happen.", UnsafeArg.of("parameter", this.value()));
    }

    @Override
    public String userFriendlyName() {
        return "parameter literal";
    }

    @Value.Parameter
    public abstract Parameter<?> value();

    @Unsafe
    private String getStringRepresentationForConcreteValue(Object value, LatitudeExpressionVisitor<String> expressionResolver) {
        if (value instanceof ColumnInfo) {
            return String.format("\"%s\"", ((ColumnInfo)value).getName());
        }
        if (value instanceof String) {
            return StringLiteral.of((String)value).getExpressionStringRepresentation(expressionResolver);
        }
        return value.toString();
    }
}

