/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import com.palantir.logsafe.Unsafe;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableStringLiteral;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.Literal;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableStringLiteral.class)
@JsonSerialize(as=ImmutableStringLiteral.class)
@Value.Immutable
public abstract class StringLiteral
extends Literal {
    public static StringLiteral of(String value) {
        return ImmutableStringLiteral.of(value);
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return Expression.ReturnType.STRING.getAttributes();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> _expressionResolver) {
        return "'" + this.value().replace("'", "''") + "'";
    }

    @Override
    public String userFriendlyName() {
        return "string literal";
    }

    @Unsafe
    @Value.Parameter
    public abstract String value();
}

