/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import latitude.api.column.ColumnAttribute;
import latitude.api.exception.ContourExceptions;
import latitude.api.expression.Expression;
import latitude.api.expression.ImmutableUnaryExpression;
import latitude.api.expression.LatitudeExpressionVisitor;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableUnaryExpression.class)
@JsonSerialize(as=ImmutableUnaryExpression.class)
@Value.Immutable
public abstract class UnaryExpression
extends Expression {
    private static final String MINUS_CONSTANT = "-";
    private static final String PLUS_CONSTANT = "+";
    private static final String NOT_CONSTANT = "NOT";
    private static final String IS_NULL_CONSTANT = "IS NULL";
    private static final String NOT_NULL_CONSTANT = "NOT NULL";

    public static UnaryExpression of(UnaryOperation operation, Expression expression) {
        return ImmutableUnaryExpression.of(operation, expression);
    }

    @Override
    public final List<String> getSourceTables() {
        return this.expression().getSourceTables();
    }

    @Override
    public final Set<ColumnAttribute> getAttributes() {
        return this.operation().returnType.getAttributes();
    }

    @Override
    public final boolean isAggregating() {
        return this.expression().isAggregating();
    }

    @Override
    public final <T> T accept(LatitudeExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getExpressionStringRepresentation(LatitudeExpressionVisitor<String> expressionResolver) {
        if (this.operation().equals((Object)UnaryOperation.IS_NULL) || this.operation().equals((Object)UnaryOperation.NOT_NULL)) {
            return "(" + this.expression().accept(expressionResolver) + " " + this.operation().getExpressionRepresentation() + ")";
        }
        if (this.operation().equals((Object)UnaryOperation.NOT)) {
            return "(" + this.operation().getExpressionRepresentation() + " " + this.expression().accept(expressionResolver) + ")";
        }
        return this.operation().getExpressionRepresentation() + this.expression().accept(expressionResolver);
    }

    @Override
    public String userFriendlyName() {
        return "unary operation";
    }

    @Value.Parameter
    public abstract UnaryOperation operation();

    @Value.Parameter
    public abstract Expression expression();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableUnaryExpression.Builder {
    }

    public static enum UnaryOperation {
        MINUS(Expression.ReturnType.NUMBER, "-"),
        PLUS(Expression.ReturnType.NUMBER, "+"),
        NOT(Expression.ReturnType.BOOLEAN, "NOT"),
        IS_NULL(Expression.ReturnType.BOOLEAN, "IS NULL"),
        NOT_NULL(Expression.ReturnType.BOOLEAN, "NOT NULL");

        private final Expression.ReturnType returnType;
        private final String expressionRepresentation;

        private UnaryOperation(Expression.ReturnType returnType, String expressionRepresentation) {
            this.returnType = returnType;
            this.expressionRepresentation = expressionRepresentation;
        }

        public static UnaryOperation parse(String operation) {
            String op;
            switch (op = operation.toUpperCase(Locale.ROOT)) {
                case "-": {
                    return MINUS;
                }
                case "+": {
                    return PLUS;
                }
                case "NOT": {
                    return NOT;
                }
            }
            if (op.matches("IS[\\s]+NULL")) {
                return IS_NULL;
            }
            if (op.matches("NOT[\\s]+NULL")) {
                return NOT_NULL;
            }
            throw ContourExceptions.client400(String.format("Unrecognized expression operation '%s'.", op), "Unrecognized expression operation.");
        }

        public String getExpressionRepresentation() {
            return this.expressionRepresentation;
        }
    }
}

