/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression.representation;

import java.util.function.Function;
import latitude.api.expression.Expression;
import latitude.api.expression.LatitudeExpressionVisitor;
import latitude.api.expression.representation.ExpressionStringBuilderVisitor;

public interface ExpressionStringBuilder
extends Function<Expression, String> {
    public static final ExpressionStringBuilder DEFAULT = new ExpressionStringBuilder(){};

    default public String buildString(Expression expression) {
        return expression.accept(new ExpressionStringBuilderVisitor());
    }

    @Override
    default public String apply(Expression expression) {
        return this.buildString(expression);
    }

    public static ExpressionStringBuilder from(final LatitudeExpressionVisitor<String> expressionVisitor) {
        return new ExpressionStringBuilder(){

            @Override
            public String buildString(Expression expression) {
                return (String)expression.accept(expressionVisitor);
            }
        };
    }
}

