/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression.representation;

import latitude.api.expression.Frame;
import latitude.api.expression.ParameterLiteral;
import latitude.api.expression.representation.ExpressionStringBuilder;

public final class FrameRepresentation {
    private final Frame frame;
    private final ExpressionStringBuilder expressionStringBuilder;

    public static FrameRepresentation create(Frame frame) {
        return new FrameRepresentation(frame, ExpressionStringBuilder.DEFAULT);
    }

    private FrameRepresentation(Frame frame, ExpressionStringBuilder expressionStringBuilder) {
        this.frame = frame;
        this.expressionStringBuilder = expressionStringBuilder;
    }

    public String toString() {
        if (this.frame.type().equals((Object)Frame.FrameType.CURRENT_ROW)) {
            return "CURRENT ROW";
        }
        String range = this.frame.range().map(ParameterLiteral::of).map(this.expressionStringBuilder).orElse("UNBOUNDED");
        return range + " " + this.frame.type().name();
    }
}

