/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.expression.representation;

import java.util.function.Function;
import latitude.api.expression.FrameBy;
import latitude.api.expression.FunctionWindow;
import latitude.api.expression.representation.ExpressionStringBuilder;
import latitude.api.expression.representation.FrameByRepresentation;
import shadow.palantir.driver.one.util.streamex.StreamEx;

public final class FunctionWindowRepresentation {
    private final FunctionWindow window;
    private final ExpressionStringBuilder expressionStringBuilder;

    public FunctionWindowRepresentation(FunctionWindow window, ExpressionStringBuilder expressionStringBuilder) {
        this.window = window;
        this.expressionStringBuilder = expressionStringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" OVER (");
        this.addPartitionBys(stringBuilder);
        this.addOrderBys(stringBuilder);
        this.addFrameBys(stringBuilder);
        stringBuilder.append("\n)");
        return stringBuilder.toString();
    }

    private void addPartitionBys(StringBuilder stringBuilder) {
        this.window.partitionBy().ifPresent(pb -> {
            stringBuilder.append("\n    PARTITION BY ");
            String columns = ((StreamEx)StreamEx.of(pb.columns()).map((Function)this.expressionStringBuilder)).joining(", ");
            stringBuilder.append(columns);
        });
    }

    private void addOrderBys(StringBuilder stringBuilder) {
        if (!this.window.orderBys().isEmpty()) {
            stringBuilder.append("\n    ORDER BY ");
            String columns = ((StreamEx)StreamEx.of(this.window.orderBys()).map(orderBy -> this.expressionStringBuilder.buildString(orderBy.column()) + " " + orderBy.order().toString() + orderBy.nullsOrder().map(nullsOrder -> " " + nullsOrder.toString()).orElse(""))).joining(", ");
            stringBuilder.append(columns);
        }
    }

    private void addFrameBys(StringBuilder stringBuilder) {
        this.window.frameBy().ifPresent(frameBy -> {
            stringBuilder.append("\n    ");
            stringBuilder.append(new FrameByRepresentation((FrameBy)frameBy));
        });
    }
}

