/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.ColumnInfo;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.parameters.Parameter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class ColumnContainedInFilter
implements LatitudeFilter {
    private final Set<ColumnInfo> columns;
    private final Set<Parameter<String>> values;
    private final boolean wildcard;
    private final boolean isCaseSensitive;
    private final boolean isWildcardEscapeEnabled;

    public ColumnContainedInFilter(@JsonProperty(value="columns") Set<ColumnInfo> columns, @JsonProperty(value="values") Set<Parameter<String>> values, @JsonProperty(value="wildcard") boolean wildcard, @JsonProperty(value="caseSensitive") Optional<Boolean> isCaseSensitive, @JsonProperty(value="wildcardEscapeEnabled") Optional<Boolean> isWildcardEscapeEnabled) {
        this.columns = columns;
        this.values = values;
        this.wildcard = wildcard;
        this.isCaseSensitive = isCaseSensitive.orElse(false);
        this.isWildcardEscapeEnabled = isWildcardEscapeEnabled.orElse(false);
    }

    public Set<ColumnInfo> getColumns() {
        return this.columns;
    }

    public Set<Parameter<String>> getValues() {
        return this.values;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isWildcardEscapeEnabled() {
        return this.isWildcardEscapeEnabled;
    }

    @JsonIgnore
    public Set<String> getConcreteValues() {
        return this.values.stream().map(Parameter::asConcreteValue).collect(Collectors.toSet());
    }

    @Override
    public String getType() {
        return "ColumnContainedInFilter";
    }

    @Override
    public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.values, this.wildcard, this.isCaseSensitive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnContainedInFilter other = (ColumnContainedInFilter)obj;
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.values, other.values) && this.wildcard == other.wildcard && this.isCaseSensitive == other.isCaseSensitive && this.isWildcardEscapeEnabled == other.isWildcardEscapeEnabled;
    }

    public String toString() {
        return "ColumnContainedInFilter [columns=" + this.columns + ", values=" + this.values + ", wildcard=" + this.wildcard + ", isCaseSensitive=" + this.isCaseSensitive + ", isWildcardEscapeEnabled=" + this.isWildcardEscapeEnabled + "]";
    }
}

