/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import java.util.Arrays;
import java.util.Objects;
import latitude.api.column.ColumnInfo;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.filters.Mode;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class ColumnEqualsArrayFilter
implements LatitudeFilter {
    private final ColumnInfo column;
    private final Object[] comparisonArray;
    private final Mode mode;

    @JsonCreator
    public ColumnEqualsArrayFilter(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="comparisonArray") Object[] comparisonArray, @JsonProperty(value="mode") Mode mode) {
        this.column = column;
        this.comparisonArray = Arrays.copyOf(comparisonArray, comparisonArray.length);
        this.mode = mode;
    }

    public ColumnInfo getColumn() {
        return this.column;
    }

    public Object[] getComparisonArray() {
        return Arrays.copyOf(this.comparisonArray, this.comparisonArray.length);
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public String getType() {
        return "ColumnEqualsArrayFilter";
    }

    @Override
    public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, Arrays.hashCode(this.comparisonArray), this.mode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnEqualsArrayFilter other = (ColumnEqualsArrayFilter)obj;
        return Objects.equals(this.column, other.column) && Arrays.equals(this.comparisonArray, other.comparisonArray) && Objects.equals((Object)this.mode, (Object)other.mode);
    }

    public String toString() {
        return "ColumnEqualsArrayFilter [column=" + this.column + ", comparisonArray=" + Arrays.toString(this.comparisonArray) + ", mode=" + this.mode + "]";
    }
}

