/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import java.util.Objects;
import java.util.Optional;
import latitude.api.column.ColumnInfo;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.filters.Mode;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class ColumnEqualsConstantFilter
implements LatitudeFilter {
    private final ColumnInfo column;
    private final Optional<String> value;
    private final Mode mode;

    @JsonCreator
    public ColumnEqualsConstantFilter(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="value") Optional<String> value, @JsonProperty(value="mode") Optional<Mode> mode) {
        this(column, value, mode.orElse(Mode.EQUALS));
    }

    public ColumnEqualsConstantFilter(ColumnInfo column, Optional<String> value, Mode mode) {
        this.column = column;
        this.value = value;
        this.mode = mode;
    }

    public ColumnInfo getColumn() {
        return this.column;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<String> getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public String getType() {
        return "ColumnEqualsConstantFilter";
    }

    @Override
    public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.value, this.mode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnEqualsConstantFilter other = (ColumnEqualsConstantFilter)obj;
        return Objects.equals(this.column, other.column) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.mode, (Object)other.mode);
    }

    public String toString() {
        return "ColumnEqualsConstantFilter [column=" + this.column + ", value=" + this.value + ", mode=" + this.mode + "]";
    }
}

