/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import com.palantir.logsafe.Preconditions;
import java.util.Objects;
import latitude.api.column.ColumnInfo;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.parameters.Parameter;
import latitude.api.util.TimeZones;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class DateColumnEqualsDateFilter
implements LatitudeFilter {
    private final ColumnInfo column;
    private final Parameter<String> value;
    private final String timeZone;

    public DateColumnEqualsDateFilter(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="value") Parameter<String> value, @JsonProperty(value="timeZone") String timeZone) {
        this.column = Preconditions.checkNotNull(column, "column must not be null");
        this.value = Preconditions.checkNotNull(value, "value must not be null");
        this.timeZone = TimeZones.validateAndNormalizeTimezone(timeZone, column.getName());
    }

    public ColumnInfo getColumn() {
        return this.column;
    }

    public Parameter<String> getValue() {
        return this.value;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getType() {
        return "DateColumnEqualsDateFilter";
    }

    @Override
    public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.value, this.timeZone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateColumnEqualsDateFilter other = (DateColumnEqualsDateFilter)obj;
        return Objects.equals(this.column, other.column) && Objects.equals(this.value, other.value) && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return "DateColumnEqualsDateFilter [column=" + this.column + ", value=" + this.value + ", timeZone=" + this.timeZone + "]";
    }
}

