/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import com.palantir.logsafe.Arg;
import java.util.Objects;
import java.util.Optional;
import latitude.api.column.ColumnInfo;
import latitude.api.exception.ContourExceptions;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.parameters.Parameter;
import latitude.api.util.TimeZones;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.org.joda.time.DateTimeZone;

public final class DateColumnRangeFilter
implements LatitudeFilter {
    private final ColumnInfo column;
    private final Optional<Parameter<String>> lower;
    private final Optional<Parameter<String>> upper;
    private final boolean inclusive;
    private final String timeZone;

    public DateColumnRangeFilter(@JsonProperty(value="column") ColumnInfo column, @JsonProperty(value="lower") Optional<Parameter<String>> lower, @JsonProperty(value="upper") Optional<Parameter<String>> upper, @JsonProperty(value="inclusive") Optional<Boolean> inclusive, @JsonProperty(value="timeZone") String timeZone) {
        ContourExceptions.client400PreconditionWithSafeMessage(lower.isPresent() || upper.isPresent(), "Date column range filter must have either an upper or a lower bound.", new Arg[0]);
        this.column = column;
        this.lower = lower;
        this.upper = upper;
        this.inclusive = inclusive.orElse(true);
        this.timeZone = TimeZones.validateAndNormalizeTimezone(timeZone != null ? timeZone : DateTimeZone.getDefault().toString(), column.getName());
    }

    public ColumnInfo getColumn() {
        return this.column;
    }

    public Optional<Parameter<String>> getLower() {
        return this.lower;
    }

    public Optional<Parameter<String>> getUpper() {
        return this.upper;
    }

    public boolean getInclusive() {
        return this.inclusive;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getType() {
        return "DateColumnRangeFilter";
    }

    @Override
    public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.upper, this.lower, this.inclusive, this.timeZone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateColumnRangeFilter other = (DateColumnRangeFilter)obj;
        return Objects.equals(this.column, other.column) && Objects.equals(this.upper, other.upper) && Objects.equals(this.lower, other.lower) && this.inclusive == other.inclusive && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return "DateColumnRangeFilter [column=" + this.column + ", lower=" + this.lower + ", upper=" + this.upper + ", inclusive=" + this.inclusive + ", timeZone=" + this.timeZone + "]";
    }
}

