/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.List;
import latitude.api.filter.LatitudeFilter;
import latitude.api.filter.LatitudeFilterVisitor;
import latitude.api.filters.ImmutableGeoPolygonFilter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.geojson.LngLatAlt;
import shadow.palantir.driver.com.palantir.geojson.Polygon;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableGeoPolygonFilter.class)
@JsonSerialize(as=ImmutableGeoPolygonFilter.class)
@Value.Immutable
public interface GeoPolygonFilter
extends LatitudeFilter {
    public Polygon polygon();

    public String latitudeColumn();

    public String longitudeColumn();

    @Value.Check
    default public void check() {
        if (this.polygon().getCoordinates().isEmpty()) {
            throw new SafeIllegalArgumentException("Polygon must have at least one ring", UnsafeArg.of("polygon", this.polygon()));
        }
        for (List<LngLatAlt> ring : this.polygon().getCoordinates()) {
            for (LngLatAlt p : ring) {
                if (p.getLatitude() < -90.0 || p.getLatitude() > 90.0) {
                    throw new SafeIllegalArgumentException("Polygon must only contain latitudes in the range [-90, 90]", UnsafeArg.of("latitude", p.getLatitude()), UnsafeArg.of("polygon", this.polygon()));
                }
                if (!(p.getLongitude() < -180.0) && !(p.getLongitude() > 180.0)) continue;
                throw new SafeIllegalArgumentException("Polygon must only contain longitudes in the range [-180, 180]", UnsafeArg.of("longitude", p.getLongitude()), UnsafeArg.of("polygon", this.polygon()));
            }
        }
    }

    @Override
    default public String getType() {
        return "GeoRadiusFilter";
    }

    @Override
    default public <T, V extends LatitudeFilterVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static GeoPolygonFilter of(Polygon polygon, String latitude, String longitude) {
        return ImmutableGeoPolygonFilter.builder().polygon(polygon).latitudeColumn(latitude).longitudeColumn(longitude).build();
    }
}

