/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.filters;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.filters.GeoPolygonFilter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.geojson.Polygon;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeoPolygonFilter", generator="Immutables")
@Immutable
public final class ImmutableGeoPolygonFilter
implements GeoPolygonFilter {
    private final Polygon polygon;
    private final String latitudeColumn;
    private final String longitudeColumn;

    private ImmutableGeoPolygonFilter(Polygon polygon, String latitudeColumn, String longitudeColumn) {
        this.polygon = polygon;
        this.latitudeColumn = latitudeColumn;
        this.longitudeColumn = longitudeColumn;
    }

    @Override
    @JsonProperty(value="polygon")
    public Polygon polygon() {
        return this.polygon;
    }

    @Override
    @JsonProperty(value="latitudeColumn")
    public String latitudeColumn() {
        return this.latitudeColumn;
    }

    @Override
    @JsonProperty(value="longitudeColumn")
    public String longitudeColumn() {
        return this.longitudeColumn;
    }

    public final ImmutableGeoPolygonFilter withPolygon(Polygon value) {
        if (this.polygon == value) {
            return this;
        }
        Polygon newValue = Objects.requireNonNull(value, "polygon");
        return ImmutableGeoPolygonFilter.validate(new ImmutableGeoPolygonFilter(newValue, this.latitudeColumn, this.longitudeColumn));
    }

    public final ImmutableGeoPolygonFilter withLatitudeColumn(String value) {
        String newValue = Objects.requireNonNull(value, "latitudeColumn");
        if (this.latitudeColumn.equals(newValue)) {
            return this;
        }
        return ImmutableGeoPolygonFilter.validate(new ImmutableGeoPolygonFilter(this.polygon, newValue, this.longitudeColumn));
    }

    public final ImmutableGeoPolygonFilter withLongitudeColumn(String value) {
        String newValue = Objects.requireNonNull(value, "longitudeColumn");
        if (this.longitudeColumn.equals(newValue)) {
            return this;
        }
        return ImmutableGeoPolygonFilter.validate(new ImmutableGeoPolygonFilter(this.polygon, this.latitudeColumn, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPolygonFilter && this.equalTo(0, (ImmutableGeoPolygonFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeoPolygonFilter another) {
        return this.polygon.equals(another.polygon) && this.latitudeColumn.equals(another.latitudeColumn) && this.longitudeColumn.equals(another.longitudeColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.polygon.hashCode();
        h += (h << 5) + this.latitudeColumn.hashCode();
        h += (h << 5) + this.longitudeColumn.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeoPolygonFilter").omitNullValues().add("polygon", this.polygon).add("latitudeColumn", this.latitudeColumn).add("longitudeColumn", this.longitudeColumn).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeoPolygonFilter fromJson(Json json) {
        Builder builder = ImmutableGeoPolygonFilter.builder();
        if (json.polygon != null) {
            builder.polygon(json.polygon);
        }
        if (json.latitudeColumn != null) {
            builder.latitudeColumn(json.latitudeColumn);
        }
        if (json.longitudeColumn != null) {
            builder.longitudeColumn(json.longitudeColumn);
        }
        return builder.build();
    }

    private static ImmutableGeoPolygonFilter validate(ImmutableGeoPolygonFilter instance) {
        instance.check();
        return instance;
    }

    public static ImmutableGeoPolygonFilter copyOf(GeoPolygonFilter instance) {
        if (instance instanceof ImmutableGeoPolygonFilter) {
            return (ImmutableGeoPolygonFilter)instance;
        }
        return ImmutableGeoPolygonFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeoPolygonFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_POLYGON = 1L;
        private static final long INIT_BIT_LATITUDE_COLUMN = 2L;
        private static final long INIT_BIT_LONGITUDE_COLUMN = 4L;
        private long initBits = 7L;
        @Nullable
        private Polygon polygon;
        @Nullable
        private String latitudeColumn;
        @Nullable
        private String longitudeColumn;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoPolygonFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.polygon(instance.polygon());
            this.latitudeColumn(instance.latitudeColumn());
            this.longitudeColumn(instance.longitudeColumn());
            return this;
        }

        @JsonProperty(value="polygon")
        @CanIgnoreReturnValue
        public final Builder polygon(Polygon polygon) {
            this.polygon = Objects.requireNonNull(polygon, "polygon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="latitudeColumn")
        @CanIgnoreReturnValue
        public final Builder latitudeColumn(String latitudeColumn) {
            this.latitudeColumn = Objects.requireNonNull(latitudeColumn, "latitudeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="longitudeColumn")
        @CanIgnoreReturnValue
        public final Builder longitudeColumn(String longitudeColumn) {
            this.longitudeColumn = Objects.requireNonNull(longitudeColumn, "longitudeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGeoPolygonFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGeoPolygonFilter.validate(new ImmutableGeoPolygonFilter(this.polygon, this.latitudeColumn, this.longitudeColumn));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("polygon");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("latitudeColumn");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("longitudeColumn");
            }
            return "Cannot build GeoPolygonFilter, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeoPolygonFilter", generator="Immutables")
    static final class Json
    implements GeoPolygonFilter {
        @Nullable
        Polygon polygon;
        @Nullable
        String latitudeColumn;
        @Nullable
        String longitudeColumn;

        Json() {
        }

        @JsonProperty(value="polygon")
        public void setPolygon(Polygon polygon) {
            this.polygon = polygon;
        }

        @JsonProperty(value="latitudeColumn")
        public void setLatitudeColumn(String latitudeColumn) {
            this.latitudeColumn = latitudeColumn;
        }

        @JsonProperty(value="longitudeColumn")
        public void setLongitudeColumn(String longitudeColumn) {
            this.longitudeColumn = longitudeColumn;
        }

        @Override
        public Polygon polygon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String latitudeColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String longitudeColumn() {
            throw new UnsupportedOperationException();
        }
    }
}

