/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.graph;

import java.util.Objects;
import java.util.UUID;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class GraphId {
    private final UUID id;

    @JsonCreator
    public GraphId(@JsonProperty(value="id") UUID id) {
        this.id = id;
    }

    @JsonCreator
    public static GraphId fromString(String uuid) {
        return new GraphId(UUID.fromString(uuid));
    }

    public static GraphId of(UUID uuid) {
        return new GraphId(uuid);
    }

    public UUID getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GraphId other = (GraphId)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String toString() {
        return "" + this.id;
    }

    public static GraphId create() {
        return new GraphId(UUID.randomUUID());
    }
}

