/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.graph;

import java.util.Objects;
import java.util.UUID;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class NodeId
implements Comparable<NodeId> {
    private final UUID id;

    @JsonCreator
    public NodeId(@JsonProperty(value="id") UUID id) {
        this.id = id;
    }

    @JsonCreator
    public static NodeId fromString(String uuid) {
        return new NodeId(UUID.fromString(uuid));
    }

    public static NodeId of(UUID uuid) {
        return new NodeId(uuid);
    }

    public static NodeId valueOf(String nodeId) {
        return NodeId.fromString(nodeId);
    }

    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return "" + this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeId other = (NodeId)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public static NodeId create() {
        return new NodeId(UUID.randomUUID());
    }

    @Override
    public int compareTo(NodeId other) {
        return this.getId().compareTo(other.getId());
    }
}

