/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.graph.boards.combinecolumns;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.one.util.streamex.StreamEx;

public enum CombinedColumnPosition {
    LEFT_OF_COMBINING_COLUMNS,
    LAST_COLUMN;

    private static final SafeLogger log;
    public static final CombinedColumnPosition DEFAULT_VALUE;
    private static final Map<String, CombinedColumnPosition> valuesByName;

    @JsonCreator
    public static CombinedColumnPosition fromString(String str) {
        String lowercaseStr = str.toLowerCase(Locale.ROOT);
        if (valuesByName.containsKey(lowercaseStr)) {
            return valuesByName.get(lowercaseStr);
        }
        log.warn("Received invalid string for combine column position deserialization: {}. Defaulting to: {}", SafeArg.of("receivedValue", str), SafeArg.of("defaultValue", DEFAULT_VALUE));
        return DEFAULT_VALUE;
    }

    static {
        log = SafeLoggerFactory.get(CombinedColumnPosition.class);
        DEFAULT_VALUE = LAST_COLUMN;
        valuesByName = StreamEx.of(CombinedColumnPosition.values()).toMap(enumValue -> enumValue.name().toLowerCase(Locale.ROOT), Function.identity());
    }
}

