/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.jackson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import latitude.api.jackson.ContourJacksonExceptions;
import latitude.api.jackson.FuzzyEnumModule;
import latitude.api.jackson.discoverable.Discoverable;
import latitude.api.jackson.discoverable.DiscoverableSubtypeResolver;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonFactory;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.module.SimpleModule;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.GuavaModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.joda.JodaModule;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.palantir.conjure.java.jackson.optimizations.ObjectMapperOptimizations;
import shadow.palantir.driver.com.palantir.conjure.java.serialization.ShimJdk7Module;

public final class ContourJackson {
    public static final ObjectMapper OBJECT_MAPPER;
    private static final ImmutableSet<Class<?>> DEFAULT_DISCOVERABLE_MARKER_CLASSES;
    private static final Set<Class<?>> AUGMENTING_DISCOVERABLE_MARKER_CLASSES;

    private ContourJackson() {
    }

    public static String prettyPrint(Object object) {
        return ContourJackson.prettyPrint(ContourJackson.getObjectMapper(), object);
    }

    public static String prettyPrint(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ContourJacksonExceptions.writeFailed(object, e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper getNewStandaloneObjectMapper() {
        return ContourJackson.newObjectMapper(new JsonFactory());
    }

    public static void addDiscoverableMarkerClass(Class<?> discoverableMarker) {
        AUGMENTING_DISCOVERABLE_MARKER_CLASSES.add(discoverableMarker);
        OBJECT_MAPPER.setSubtypeResolver(new DiscoverableSubtypeResolver((Set<Class<?>>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DEFAULT_DISCOVERABLE_MARKER_CLASSES)).addAll(AUGMENTING_DISCOVERABLE_MARKER_CLASSES)).build())));
    }

    public static String writeValueAsStringOrRuntimeException(Object object) {
        return ContourJackson.writeValueAsStringOrRuntimeException(ContourJackson.getObjectMapper(), object);
    }

    public static String writeValueAsStringOrRuntimeException(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ContourJacksonExceptions.writeFailed(object, e);
        }
    }

    public static byte[] writeValueAsBytesOrRuntimeException(Object object) {
        return ContourJackson.writeValueAsBytesOrRuntimeException(ContourJackson.getObjectMapper(), object);
    }

    public static byte[] writeValueAsBytesOrRuntimeException(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ContourJacksonExceptions.writeFailed(object, e);
        }
    }

    public static <T> T readValueOrRuntimeException(String content, Class<T> valueType) {
        return ContourJackson.readValueOrRuntimeException(ContourJackson.getObjectMapper(), content, valueType);
    }

    public static <T> T readValueOrRuntimeException(ObjectMapper objectMapper, String content, Class<T> valueType) {
        try {
            return objectMapper.readValue(content, valueType);
        }
        catch (IOException e) {
            throw ContourJacksonExceptions.readFailed(content, valueType, (Exception)e);
        }
    }

    public static <T> T readValueOrRuntimeException(String content, TypeReference<T> typeReference) {
        return ContourJackson.readValueOrRuntimeException(ContourJackson.getObjectMapper(), content, typeReference);
    }

    public static <T> T readValueOrRuntimeException(ObjectMapper objectMapper, String content, TypeReference<T> typeReference) {
        try {
            return objectMapper.readValue(content, typeReference);
        }
        catch (IOException e) {
            throw ContourJacksonExceptions.readFailed(content, typeReference, (Exception)e);
        }
    }

    public static <T> T readValueOrRuntimeException(ByteBuffer result, Class<T> clazz) {
        return ContourJackson.readValueOrRuntimeException(ContourJackson.getObjectMapper(), result, clazz);
    }

    public static <T> T readValueOrRuntimeException(ObjectMapper objectMapper, ByteBuffer result, Class<T> clazz) {
        try {
            return objectMapper.readValue((InputStream)new ByteBufferBackedInputStream(result), clazz);
        }
        catch (IOException e) {
            throw ContourJacksonExceptions.readFailed("[ByteBuffer] - will not convert contents to string in exception to save memory", clazz, (Exception)e);
        }
    }

    public static <T> T readValueOrRuntimeException(ByteBuffer result, TypeReference<T> typeReference) {
        return ContourJackson.readValueOrRuntimeException(ContourJackson.getObjectMapper(), result, typeReference);
    }

    public static <T> T readValueOrRuntimeException(ObjectMapper objectMapper, ByteBuffer result, TypeReference<T> typeReference) {
        try {
            return objectMapper.readValue((InputStream)new ByteBufferBackedInputStream(result), typeReference);
        }
        catch (IOException e) {
            throw ContourJacksonExceptions.readFailed("[ByteBuffer] - will not convert contents to string in exception to save memory", typeReference, (Exception)e);
        }
    }

    private static ObjectMapper newObjectMapper(JsonFactory inputJsonFactory) {
        ObjectMapper mapper = new ObjectMapper(inputJsonFactory.disable(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW));
        mapper.registerModule(new GuavaModule());
        mapper.registerModule(new JodaModule());
        mapper.registerModules(ObjectMapperOptimizations.createModules());
        mapper.registerModule(new ShimJdk7Module());
        mapper.registerModule(new Jdk8Module().configureAbsentsAsNulls(true));
        mapper.registerModule(new JavaTimeModule());
        mapper.registerModule(new FuzzyEnumModule());
        mapper.setSubtypeResolver(new DiscoverableSubtypeResolver(DEFAULT_DISCOVERABLE_MARKER_CLASSES));
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule(new SimpleModule(){
            {
                this.addSerializer(Date.class, new SqlDateSerializer().withFormat(false, new SimpleDateFormat("yyyy-MM-dd")));
            }
        });
        return mapper;
    }

    static {
        DEFAULT_DISCOVERABLE_MARKER_CLASSES = ImmutableSet.of(Discoverable.class);
        AUGMENTING_DISCOVERABLE_MARKER_CLASSES = ConcurrentHashMap.newKeySet();
        OBJECT_MAPPER = ContourJackson.newObjectMapper(new JsonFactory());
    }
}

