/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.jackson;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import latitude.api.exception.AbstractExceptionManager;
import latitude.api.exception.ErrorName;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ErrorType;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ServiceException;

public final class ContourJacksonExceptions
extends AbstractExceptionManager {
    private static final ErrorType WRITE_FAILED = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.WRITE_FAILED.toString());
    private static final ErrorType READ_FAILED = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.READ_FAILED.toString());
    private static final ErrorType READ_JSON_VALUE_FAILED = ErrorType.create(ErrorType.Code.INTERNAL, ErrorName.READ_JSON_VALUE_FAILED.toString());

    private ContourJacksonExceptions() {
    }

    public static ServiceException writeFailed(Object writeObject, Exception cause) {
        return new ServiceException(WRITE_FAILED, (Throwable)cause, UnsafeArg.of("writeObject", writeObject));
    }

    public static ServiceException readFailed(String content, Class<?> clazz, Exception cause) {
        return new ServiceException(READ_FAILED, (Throwable)cause, UnsafeArg.of("readContent", content), SafeArg.of("className", clazz.getSimpleName()));
    }

    public static ServiceException readFailed(String content, TypeReference<?> typeReference, Exception cause) {
        return new ServiceException(READ_FAILED, (Throwable)cause, UnsafeArg.of("readContent", content), SafeArg.of("className", typeReference.getType().getTypeName()));
    }

    public static ServiceException readFailed(Class<?> clazz, Exception cause) {
        return new ServiceException(READ_FAILED, (Throwable)cause, SafeArg.of("className", clazz.getSimpleName()));
    }

    public static ServiceException readBytesFailed(String name, Class<?> clazz, Exception cause) {
        return new ServiceException(READ_FAILED, (Throwable)cause, UnsafeArg.of("readContentName", name), SafeArg.of("className", clazz.getSimpleName()));
    }

    public static ServiceException readJsonValueFailed(String value) {
        return new ServiceException(READ_JSON_VALUE_FAILED, UnsafeArg.of("jsonValue", value));
    }
}

