/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.jackson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.Version;
import shadow.palantir.driver.com.fasterxml.jackson.databind.BeanDescription;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.palantir.driver.com.fasterxml.jackson.databind.Module;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.Deserializers;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import shadow.palantir.driver.com.google.common.base.CharMatcher;

public class FuzzyEnumModule
extends Module {
    @Override
    public String getModuleName() {
        return "permissive-enums";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addDeserializers(new PermissiveEnumDeserializers());
    }

    private static final class PermissiveEnumDeserializers
    extends Deserializers.Base {
        private PermissiveEnumDeserializers() {
        }

        @Override
        public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription desc) throws JsonMappingException {
            if (config.hasDeserializationFeatures(DeserializationFeature.READ_ENUMS_USING_TO_STRING.getMask())) {
                return null;
            }
            List<AnnotatedMethod> factoryMethods = desc.getFactoryMethods();
            if (factoryMethods != null) {
                for (AnnotatedMethod am : factoryMethods) {
                    JsonCreator creator = am.getAnnotation(JsonCreator.class);
                    if (creator == null) continue;
                    return EnumDeserializer.deserializerForCreator(config, type, am);
                }
            }
            return new PermissiveEnumDeserializer(type);
        }
    }

    private static class PermissiveEnumDeserializer
    extends StdScalarDeserializer<Enum<?>> {
        private static final long serialVersionUID = 1L;
        private final Enum<?>[] constants = (Enum[])this.handledType().getEnumConstants();
        private final List<String> acceptedValues = new ArrayList<String>();

        protected PermissiveEnumDeserializer(Class<Enum<?>> clazz) {
            super(clazz);
            for (Enum<?> constant : this.constants) {
                this.acceptedValues.add(constant.name());
            }
        }

        @Override
        public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = CharMatcher.whitespace().removeFrom(jp.getText()).replace('-', '_').replace('.', '_');
            for (Enum<?> constant : this.constants) {
                if (!constant.name().equalsIgnoreCase(text)) continue;
                return constant;
            }
            throw ctxt.weirdStringException(text, this.handledType(), String.format("not one of the values accepted for Enum class: %s", this.acceptedValues));
        }
    }
}

