/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.jackson.discoverable;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.jackson.discoverable.SubtypeFinder;

public final class MetaInfBasedSubtypeFinder
implements SubtypeFinder {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final SafeLogger log = SafeLoggerFactory.get(MetaInfBasedSubtypeFinder.class);

    @Override
    public Set<Class<?>> findSubtypes(Class<?> clazz) {
        HashSet subtypes = new HashSet();
        ArrayDeque toBeProcessed = new ArrayDeque();
        toBeProcessed.offer(clazz);
        while (!toBeProcessed.isEmpty()) {
            Class curClazz = (Class)toBeProcessed.poll();
            this.findDirectSubTypes(curClazz).stream().filter(subtype -> !subtypes.contains(subtype)).forEach(subtype -> {
                subtypes.add((Class<?>)subtype);
                toBeProcessed.offer((Class<?>)subtype);
            });
        }
        return subtypes;
    }

    private Set<Class<?>> findDirectSubTypes(Class<?> clazz) {
        return this.subTypeInfoFilesFor(clazz).stream().flatMap(infoFile -> this.loadClassesFromInfoFile((URL)infoFile).stream()).collect(Collectors.toSet());
    }

    private Set<? extends Class<?>> loadClassesFromInfoFile(URL infoFileUrl) {
        HashSet serviceClasses = new HashSet();
        try (InputStream input = infoFileUrl.openStream();
             InputStreamReader streamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    serviceClasses.add(this.classLoader().loadClass(line.trim()));
                }
                catch (ClassNotFoundException e) {
                    log.info("Unable to load {}", UnsafeArg.of("readerLine", line), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.warn("Error while reading subtype list from: {}", UnsafeArg.of("inputStreamUrl", infoFileUrl), (Throwable)e);
            return Collections.emptySet();
        }
        return serviceClasses;
    }

    private List<URL> subTypeInfoFilesFor(Class<?> clazz) {
        try {
            return Collections.unmodifiableList(Collections.list(this.classLoader().getResources(META_INF_SERVICES + clazz.getName())));
        }
        catch (IOException e) {
            log.warn("Unable to get resource {}/{}", SafeArg.of("metaInfServices", META_INF_SERVICES), SafeArg.of("className", clazz.getSimpleName()), e);
            return Collections.emptyList();
        }
    }

    private ClassLoader classLoader() {
        return this.getClass().getClassLoader();
    }
}

