/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.join;

import com.palantir.logsafe.Unsafe;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.IdentifiableColumn;
import latitude.api.column.basic.BasicColumnInfo;
import latitude.api.join.ImmutableExcludeColumnList;
import latitude.api.join.LatitudeColumnList;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonDeserialize(as=ImmutableExcludeColumnList.class)
@JsonSerialize(as=ImmutableExcludeColumnList.class)
@JsonTypeName(value="exclude")
@Value.Immutable
public abstract class ExcludeColumnList
implements LatitudeColumnList {
    @Unsafe
    public abstract Set<String> excludedColumnIdentifiers();

    @Override
    @Value.Derived
    public final List<IdentifiableColumn> getColumns(List<? extends BasicColumnInfo> inputColumns) {
        return inputColumns.stream().filter(column -> !this.excludedColumnIdentifiers().contains(column.getIdentifier())).collect(Collectors.toList());
    }

    public static ExcludeColumnList of(Set<String> excludedColumnIdentifiers) {
        return ImmutableExcludeColumnList.builder().excludedColumnIdentifiers(excludedColumnIdentifiers).build();
    }
}

