/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import latitude.api.join.MatchType;
import latitude.api.join.MatchTypeV1;
import latitude.api.join.Term;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MatchTypeV1", generator="Immutables")
@Immutable
public final class ImmutableMatchTypeV1
extends MatchTypeV1 {
    private final MatchType.TranslationMatchType type;
    private final ImmutableList<Term> terms;

    private ImmutableMatchTypeV1(MatchType.TranslationMatchType type, Iterable<? extends Term> terms) {
        this.type = Objects.requireNonNull(type, "type");
        this.terms = ImmutableList.copyOf(terms);
    }

    private ImmutableMatchTypeV1(ImmutableMatchTypeV1 original, MatchType.TranslationMatchType type, ImmutableList<Term> terms) {
        this.type = type;
        this.terms = terms;
    }

    @Override
    @JsonProperty(value="type")
    public MatchType.TranslationMatchType type() {
        return this.type;
    }

    @JsonProperty(value="terms")
    public ImmutableList<Term> terms() {
        return this.terms;
    }

    public final ImmutableMatchTypeV1 withType(MatchType.TranslationMatchType value) {
        MatchType.TranslationMatchType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableMatchTypeV1(this, newValue, this.terms);
    }

    public final ImmutableMatchTypeV1 withTerms(Term ... elements) {
        ImmutableList<Term> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchTypeV1(this, this.type, newValue);
    }

    public final ImmutableMatchTypeV1 withTerms(Iterable<? extends Term> elements) {
        if (this.terms == elements) {
            return this;
        }
        ImmutableList<Term> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchTypeV1(this, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMatchTypeV1 && this.equalTo(0, (ImmutableMatchTypeV1)another);
    }

    private boolean equalTo(int synthetic, ImmutableMatchTypeV1 another) {
        return this.type.equals((Object)another.type) && this.terms.equals(another.terms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.terms.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MatchTypeV1").omitNullValues().add("type", (Object)this.type).add("terms", this.terms).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMatchTypeV1 fromJson(Json json) {
        Builder builder = ImmutableMatchTypeV1.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.terms != null) {
            builder.addAllTerms(json.terms);
        }
        return builder.build();
    }

    public static ImmutableMatchTypeV1 of(MatchType.TranslationMatchType type, List<Term> terms) {
        return ImmutableMatchTypeV1.of(type, terms);
    }

    public static ImmutableMatchTypeV1 of(MatchType.TranslationMatchType type, Iterable<? extends Term> terms) {
        return new ImmutableMatchTypeV1(type, terms);
    }

    public static ImmutableMatchTypeV1 copyOf(MatchTypeV1 instance) {
        if (instance instanceof ImmutableMatchTypeV1) {
            return (ImmutableMatchTypeV1)instance;
        }
        return ImmutableMatchTypeV1.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MatchTypeV1", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private MatchType.TranslationMatchType type;
        private ImmutableList.Builder<Term> terms = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MatchType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MatchTypeV1 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof MatchType) {
                MatchType instance = (MatchType)object;
                this.type(instance.type());
                this.addAllTerms(instance.terms());
            }
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(MatchType.TranslationMatchType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTerms(Term element) {
            this.terms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTerms(Term ... elements) {
            this.terms.add(elements);
            return this;
        }

        @JsonProperty(value="terms")
        @CanIgnoreReturnValue
        public final Builder terms(Iterable<? extends Term> elements) {
            this.terms = ImmutableList.builder();
            return this.addAllTerms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTerms(Iterable<? extends Term> elements) {
            this.terms.addAll(elements);
            return this;
        }

        public ImmutableMatchTypeV1 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMatchTypeV1(null, this.type, (ImmutableList<Term>)this.terms.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build MatchTypeV1, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MatchTypeV1", generator="Immutables")
    static final class Json
    extends MatchTypeV1 {
        @Nullable
        MatchType.TranslationMatchType type;
        @Nullable
        List<Term> terms = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(MatchType.TranslationMatchType type) {
            this.type = type;
        }

        @JsonProperty(value="terms")
        public void setTerms(List<Term> terms) {
            this.terms = terms;
        }

        @Override
        public MatchType.TranslationMatchType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Term> terms() {
            throw new UnsupportedOperationException();
        }
    }
}

