/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.join;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.column.ColumnInfo;
import latitude.api.join.MatchType;
import latitude.api.join.Term;
import latitude.api.join.TermV1;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TermV1", generator="Immutables")
@Immutable
public final class ImmutableTermV1
extends TermV1 {
    private final MatchType.TranslationOperator operator;
    @Nullable
    private final ColumnInfo sourceColumn;
    @Nullable
    private final ColumnInfo targetColumn;

    private ImmutableTermV1(MatchType.TranslationOperator operator, Optional<? extends ColumnInfo> sourceColumn, Optional<? extends ColumnInfo> targetColumn) {
        this.operator = Objects.requireNonNull(operator, "operator");
        this.sourceColumn = sourceColumn.orElse(null);
        this.targetColumn = targetColumn.orElse(null);
    }

    private ImmutableTermV1(ImmutableTermV1 original, MatchType.TranslationOperator operator, @Nullable ColumnInfo sourceColumn, @Nullable ColumnInfo targetColumn) {
        this.operator = operator;
        this.sourceColumn = sourceColumn;
        this.targetColumn = targetColumn;
    }

    @Override
    @JsonProperty(value="operator")
    public MatchType.TranslationOperator operator() {
        return this.operator;
    }

    @Override
    @JsonProperty(value="sourceColumn")
    public Optional<ColumnInfo> sourceColumn() {
        return Optional.ofNullable(this.sourceColumn);
    }

    @Override
    @JsonProperty(value="targetColumn")
    public Optional<ColumnInfo> targetColumn() {
        return Optional.ofNullable(this.targetColumn);
    }

    public final ImmutableTermV1 withOperator(MatchType.TranslationOperator value) {
        MatchType.TranslationOperator newValue = Objects.requireNonNull(value, "operator");
        if (this.operator == newValue) {
            return this;
        }
        return new ImmutableTermV1(this, newValue, this.sourceColumn, this.targetColumn);
    }

    public final ImmutableTermV1 withSourceColumn(ColumnInfo value) {
        ColumnInfo newValue = Objects.requireNonNull(value, "sourceColumn");
        if (this.sourceColumn == newValue) {
            return this;
        }
        return new ImmutableTermV1(this, this.operator, newValue, this.targetColumn);
    }

    public final ImmutableTermV1 withSourceColumn(Optional<? extends ColumnInfo> optional) {
        ColumnInfo value = optional.orElse(null);
        if (this.sourceColumn == value) {
            return this;
        }
        return new ImmutableTermV1(this, this.operator, value, this.targetColumn);
    }

    public final ImmutableTermV1 withTargetColumn(ColumnInfo value) {
        ColumnInfo newValue = Objects.requireNonNull(value, "targetColumn");
        if (this.targetColumn == newValue) {
            return this;
        }
        return new ImmutableTermV1(this, this.operator, this.sourceColumn, newValue);
    }

    public final ImmutableTermV1 withTargetColumn(Optional<? extends ColumnInfo> optional) {
        ColumnInfo value = optional.orElse(null);
        if (this.targetColumn == value) {
            return this;
        }
        return new ImmutableTermV1(this, this.operator, this.sourceColumn, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTermV1 && this.equalTo(0, (ImmutableTermV1)another);
    }

    private boolean equalTo(int synthetic, ImmutableTermV1 another) {
        return this.operator.equals((Object)another.operator) && Objects.equals(this.sourceColumn, another.sourceColumn) && Objects.equals(this.targetColumn, another.targetColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operator.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceColumn);
        h += (h << 5) + Objects.hashCode(this.targetColumn);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TermV1").omitNullValues().add("operator", (Object)this.operator).add("sourceColumn", this.sourceColumn).add("targetColumn", this.targetColumn).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTermV1 fromJson(Json json) {
        Builder builder = ImmutableTermV1.builder();
        if (json.operator != null) {
            builder.operator(json.operator);
        }
        if (json.sourceColumn != null) {
            builder.sourceColumn(json.sourceColumn);
        }
        if (json.targetColumn != null) {
            builder.targetColumn(json.targetColumn);
        }
        return builder.build();
    }

    public static ImmutableTermV1 of(MatchType.TranslationOperator operator, Optional<? extends ColumnInfo> sourceColumn, Optional<? extends ColumnInfo> targetColumn) {
        return new ImmutableTermV1(operator, sourceColumn, targetColumn);
    }

    public static ImmutableTermV1 copyOf(TermV1 instance) {
        if (instance instanceof ImmutableTermV1) {
            return (ImmutableTermV1)instance;
        }
        return ImmutableTermV1.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TermV1", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OPERATOR = 1L;
        private long initBits = 1L;
        @Nullable
        private MatchType.TranslationOperator operator;
        @Nullable
        private ColumnInfo sourceColumn;
        @Nullable
        private ColumnInfo targetColumn;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Term instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TermV1 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof Term) {
                Optional<ColumnInfo> sourceColumnOptional;
                Term instance = (Term)object;
                this.operator(instance.operator());
                Optional<ColumnInfo> targetColumnOptional = instance.targetColumn();
                if (targetColumnOptional.isPresent()) {
                    this.targetColumn(targetColumnOptional);
                }
                if ((sourceColumnOptional = instance.sourceColumn()).isPresent()) {
                    this.sourceColumn(sourceColumnOptional);
                }
            }
        }

        @JsonProperty(value="operator")
        @CanIgnoreReturnValue
        public final Builder operator(MatchType.TranslationOperator operator) {
            this.operator = Objects.requireNonNull(operator, "operator");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceColumn(ColumnInfo sourceColumn) {
            this.sourceColumn = Objects.requireNonNull(sourceColumn, "sourceColumn");
            return this;
        }

        @JsonProperty(value="sourceColumn")
        @CanIgnoreReturnValue
        public final Builder sourceColumn(Optional<? extends ColumnInfo> sourceColumn) {
            this.sourceColumn = sourceColumn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetColumn(ColumnInfo targetColumn) {
            this.targetColumn = Objects.requireNonNull(targetColumn, "targetColumn");
            return this;
        }

        @JsonProperty(value="targetColumn")
        @CanIgnoreReturnValue
        public final Builder targetColumn(Optional<? extends ColumnInfo> targetColumn) {
            this.targetColumn = targetColumn.orElse(null);
            return this;
        }

        public ImmutableTermV1 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTermV1(null, this.operator, this.sourceColumn, this.targetColumn);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operator");
            }
            return "Cannot build TermV1, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TermV1", generator="Immutables")
    static final class Json
    extends TermV1 {
        @Nullable
        MatchType.TranslationOperator operator;
        @Nullable
        Optional<ColumnInfo> sourceColumn = Optional.empty();
        @Nullable
        Optional<ColumnInfo> targetColumn = Optional.empty();

        Json() {
        }

        @JsonProperty(value="operator")
        public void setOperator(MatchType.TranslationOperator operator) {
            this.operator = operator;
        }

        @JsonProperty(value="sourceColumn")
        public void setSourceColumn(Optional<ColumnInfo> sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        @JsonProperty(value="targetColumn")
        public void setTargetColumn(Optional<ColumnInfo> targetColumn) {
            this.targetColumn = targetColumn;
        }

        @Override
        public MatchType.TranslationOperator operator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ColumnInfo> sourceColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ColumnInfo> targetColumn() {
            throw new UnsupportedOperationException();
        }
    }
}

