/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.join;

import java.util.Optional;
import latitude.api.column.ColumnInfo;
import latitude.api.join.ImmutableTermV1;
import latitude.api.join.MatchType;
import latitude.api.join.Term;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableTermV1.class)
@JsonSerialize(as=ImmutableTermV1.class)
@Value.Immutable
public abstract class TermV1
implements Term {
    @Override
    @Value.Parameter
    public abstract MatchType.TranslationOperator operator();

    @Override
    @Value.Parameter
    public abstract Optional<ColumnInfo> sourceColumn();

    @Override
    @Value.Parameter
    public abstract Optional<ColumnInfo> targetColumn();

    public static TermV1 of(MatchType.TranslationOperator operator, ColumnInfo sourceColumn, ColumnInfo targetColumn) {
        return ImmutableTermV1.of(operator, Optional.ofNullable(sourceColumn), Optional.ofNullable(targetColumn));
    }

    public static TermV1 of(MatchType.TranslationOperator operator, ColumnInfo sourceColumn, Optional<ColumnInfo> targetColumn) {
        return ImmutableTermV1.of(operator, Optional.ofNullable(sourceColumn), targetColumn);
    }

    public static TermV1 of(MatchType.TranslationOperator operator) {
        return ImmutableTermV1.of(operator, Optional.empty(), Optional.empty());
    }

    @Override
    public final TermV1 withNewSource(ColumnInfo newSourceColumn) {
        return TermV1.of(this.operator(), newSourceColumn, this.targetColumn());
    }

    @Override
    public final TermV1 withNewColumns(ColumnInfo newSourceColumn, ColumnInfo newTargetColumn) {
        return TermV1.of(this.operator(), newSourceColumn, newTargetColumn);
    }
}

