/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.UserId;
import latitude.api.metrics.SourceMetadata;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SourceMetadata", generator="Immutables")
@Immutable
final class ImmutableSourceMetadata
implements SourceMetadata {
    @Nullable
    private final String graphId;
    @Nullable
    private final String nodeId;
    @Nullable
    private final String refRid;
    @Nullable
    private final ResourceIdentifier refParentRid;
    @Nullable
    private final String sourceId;
    @Nullable
    private final ResourceIdentifier sparkReporterOwningRid;
    @Nullable
    private final ResourceIdentifier resourceManagementAttributionRid;
    private final UserId userId;
    private final Set<ResourceIdentifier> datasetRids;
    @Nullable
    private final String lsdHash;
    @Nullable
    private final String lsdHashWithMetadataScrubbed;
    @Nullable
    private final String lsdHashWithDatasetAndMetadataScrubbed;
    @Nullable
    private final String unresolvedLsdHash;
    @Nullable
    private final String unresolvedLsdHashWithMetadataScrubbed;
    @Nullable
    private final String unresolvedLsdHashWithDatasetAndMetadataScrubbed;

    private ImmutableSourceMetadata(@Nullable String graphId, @Nullable String nodeId, @Nullable String refRid, @Nullable ResourceIdentifier refParentRid, @Nullable String sourceId, @Nullable ResourceIdentifier sparkReporterOwningRid, @Nullable ResourceIdentifier resourceManagementAttributionRid, UserId userId, Set<ResourceIdentifier> datasetRids, @Nullable String lsdHash, @Nullable String lsdHashWithMetadataScrubbed, @Nullable String lsdHashWithDatasetAndMetadataScrubbed, @Nullable String unresolvedLsdHash, @Nullable String unresolvedLsdHashWithMetadataScrubbed, @Nullable String unresolvedLsdHashWithDatasetAndMetadataScrubbed) {
        this.graphId = graphId;
        this.nodeId = nodeId;
        this.refRid = refRid;
        this.refParentRid = refParentRid;
        this.sourceId = sourceId;
        this.sparkReporterOwningRid = sparkReporterOwningRid;
        this.resourceManagementAttributionRid = resourceManagementAttributionRid;
        this.userId = userId;
        this.datasetRids = datasetRids;
        this.lsdHash = lsdHash;
        this.lsdHashWithMetadataScrubbed = lsdHashWithMetadataScrubbed;
        this.lsdHashWithDatasetAndMetadataScrubbed = lsdHashWithDatasetAndMetadataScrubbed;
        this.unresolvedLsdHash = unresolvedLsdHash;
        this.unresolvedLsdHashWithMetadataScrubbed = unresolvedLsdHashWithMetadataScrubbed;
        this.unresolvedLsdHashWithDatasetAndMetadataScrubbed = unresolvedLsdHashWithDatasetAndMetadataScrubbed;
    }

    @Override
    @JsonProperty(value="graphId")
    public Optional<String> graphId() {
        return Optional.ofNullable(this.graphId);
    }

    @Override
    @JsonProperty(value="nodeId")
    public Optional<String> nodeId() {
        return Optional.ofNullable(this.nodeId);
    }

    @Override
    @JsonProperty(value="refRid")
    public Optional<String> refRid() {
        return Optional.ofNullable(this.refRid);
    }

    @Override
    @JsonProperty(value="refParentRid")
    public Optional<ResourceIdentifier> refParentRid() {
        return Optional.ofNullable(this.refParentRid);
    }

    @Override
    @JsonProperty(value="sourceId")
    public Optional<String> sourceId() {
        return Optional.ofNullable(this.sourceId);
    }

    @Override
    @JsonProperty(value="sparkReporterOwningRid")
    public Optional<ResourceIdentifier> sparkReporterOwningRid() {
        return Optional.ofNullable(this.sparkReporterOwningRid);
    }

    @Override
    @JsonProperty(value="resourceManagementAttributionRid")
    public Optional<ResourceIdentifier> resourceManagementAttributionRid() {
        return Optional.ofNullable(this.resourceManagementAttributionRid);
    }

    @Override
    @JsonProperty(value="userId")
    public UserId userId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="datasetRids")
    public Set<ResourceIdentifier> datasetRids() {
        return this.datasetRids;
    }

    @Override
    @JsonProperty(value="lsdHash")
    public Optional<String> lsdHash() {
        return Optional.ofNullable(this.lsdHash);
    }

    @Override
    @JsonProperty(value="lsdHashWithMetadataScrubbed")
    public Optional<String> lsdHashWithMetadataScrubbed() {
        return Optional.ofNullable(this.lsdHashWithMetadataScrubbed);
    }

    @Override
    @JsonProperty(value="lsdHashWithDatasetAndMetadataScrubbed")
    public Optional<String> lsdHashWithDatasetAndMetadataScrubbed() {
        return Optional.ofNullable(this.lsdHashWithDatasetAndMetadataScrubbed);
    }

    @Override
    @JsonProperty(value="unresolvedLsdHash")
    public Optional<String> unresolvedLsdHash() {
        return Optional.ofNullable(this.unresolvedLsdHash);
    }

    @Override
    @JsonProperty(value="unresolvedLsdHashWithMetadataScrubbed")
    public Optional<String> unresolvedLsdHashWithMetadataScrubbed() {
        return Optional.ofNullable(this.unresolvedLsdHashWithMetadataScrubbed);
    }

    @Override
    @JsonProperty(value="unresolvedLsdHashWithDatasetAndMetadataScrubbed")
    public Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbed() {
        return Optional.ofNullable(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withGraphId(String value) {
        String newValue = Objects.requireNonNull(value, "graphId");
        if (Objects.equals(this.graphId, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(newValue, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withGraphId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphId, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(value, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (Objects.equals(this.nodeId, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, newValue, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withNodeId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nodeId, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, value, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withRefRid(String value) {
        String newValue = Objects.requireNonNull(value, "refRid");
        if (Objects.equals(this.refRid, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, newValue, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withRefRid(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.refRid, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, value, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withRefParentRid(ResourceIdentifier value) {
        ResourceIdentifier newValue = Objects.requireNonNull(value, "refParentRid");
        if (this.refParentRid == newValue) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, newValue, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withRefParentRid(Optional<? extends ResourceIdentifier> optional) {
        ResourceIdentifier value = optional.orElse(null);
        if (this.refParentRid == value) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, value, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withSourceId(String value) {
        String newValue = Objects.requireNonNull(value, "sourceId");
        if (Objects.equals(this.sourceId, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, newValue, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withSourceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sourceId, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, value, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withSparkReporterOwningRid(ResourceIdentifier value) {
        ResourceIdentifier newValue = Objects.requireNonNull(value, "sparkReporterOwningRid");
        if (this.sparkReporterOwningRid == newValue) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, newValue, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withSparkReporterOwningRid(Optional<? extends ResourceIdentifier> optional) {
        ResourceIdentifier value = optional.orElse(null);
        if (this.sparkReporterOwningRid == value) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, value, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withResourceManagementAttributionRid(ResourceIdentifier value) {
        ResourceIdentifier newValue = Objects.requireNonNull(value, "resourceManagementAttributionRid");
        if (this.resourceManagementAttributionRid == newValue) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, newValue, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withResourceManagementAttributionRid(Optional<? extends ResourceIdentifier> optional) {
        ResourceIdentifier value = optional.orElse(null);
        if (this.resourceManagementAttributionRid == value) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, value, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUserId(UserId value) {
        if (this.userId == value) {
            return this;
        }
        UserId newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, newValue, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withDatasetRids(ResourceIdentifier ... elements) {
        Set<ResourceIdentifier> newValue = ImmutableSourceMetadata.createUnmodifiableSet(ImmutableSourceMetadata.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, newValue, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withDatasetRids(Iterable<? extends ResourceIdentifier> elements) {
        if (this.datasetRids == elements) {
            return this;
        }
        Set<ResourceIdentifier> newValue = ImmutableSourceMetadata.createUnmodifiableSet(ImmutableSourceMetadata.createSafeList(elements, true, false));
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, newValue, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHash(String value) {
        String newValue = Objects.requireNonNull(value, "lsdHash");
        if (Objects.equals(this.lsdHash, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, newValue, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lsdHash, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, value, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHashWithMetadataScrubbed(String value) {
        String newValue = Objects.requireNonNull(value, "lsdHashWithMetadataScrubbed");
        if (Objects.equals(this.lsdHashWithMetadataScrubbed, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, newValue, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHashWithMetadataScrubbed(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lsdHashWithMetadataScrubbed, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, value, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHashWithDatasetAndMetadataScrubbed(String value) {
        String newValue = Objects.requireNonNull(value, "lsdHashWithDatasetAndMetadataScrubbed");
        if (Objects.equals(this.lsdHashWithDatasetAndMetadataScrubbed, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, newValue, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withLsdHashWithDatasetAndMetadataScrubbed(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lsdHashWithDatasetAndMetadataScrubbed, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, value, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHash(String value) {
        String newValue = Objects.requireNonNull(value, "unresolvedLsdHash");
        if (Objects.equals(this.unresolvedLsdHash, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, newValue, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.unresolvedLsdHash, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, value, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHashWithMetadataScrubbed(String value) {
        String newValue = Objects.requireNonNull(value, "unresolvedLsdHashWithMetadataScrubbed");
        if (Objects.equals(this.unresolvedLsdHashWithMetadataScrubbed, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, newValue, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHashWithMetadataScrubbed(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.unresolvedLsdHashWithMetadataScrubbed, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, value, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHashWithDatasetAndMetadataScrubbed(String value) {
        String newValue = Objects.requireNonNull(value, "unresolvedLsdHashWithDatasetAndMetadataScrubbed");
        if (Objects.equals(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed, newValue)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, newValue);
    }

    public final ImmutableSourceMetadata withUnresolvedLsdHashWithDatasetAndMetadataScrubbed(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed, value)) {
            return this;
        }
        return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, this.datasetRids, this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSourceMetadata && this.equalTo(0, (ImmutableSourceMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableSourceMetadata another) {
        return Objects.equals(this.graphId, another.graphId) && Objects.equals(this.nodeId, another.nodeId) && Objects.equals(this.refRid, another.refRid) && Objects.equals(this.refParentRid, another.refParentRid) && Objects.equals(this.sourceId, another.sourceId) && Objects.equals(this.sparkReporterOwningRid, another.sparkReporterOwningRid) && Objects.equals(this.resourceManagementAttributionRid, another.resourceManagementAttributionRid) && this.userId.equals(another.userId) && this.datasetRids.equals(another.datasetRids) && Objects.equals(this.lsdHash, another.lsdHash) && Objects.equals(this.lsdHashWithMetadataScrubbed, another.lsdHashWithMetadataScrubbed) && Objects.equals(this.lsdHashWithDatasetAndMetadataScrubbed, another.lsdHashWithDatasetAndMetadataScrubbed) && Objects.equals(this.unresolvedLsdHash, another.unresolvedLsdHash) && Objects.equals(this.unresolvedLsdHashWithMetadataScrubbed, another.unresolvedLsdHashWithMetadataScrubbed) && Objects.equals(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed, another.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.graphId);
        h += (h << 5) + Objects.hashCode(this.nodeId);
        h += (h << 5) + Objects.hashCode(this.refRid);
        h += (h << 5) + Objects.hashCode(this.refParentRid);
        h += (h << 5) + Objects.hashCode(this.sourceId);
        h += (h << 5) + Objects.hashCode(this.sparkReporterOwningRid);
        h += (h << 5) + Objects.hashCode(this.resourceManagementAttributionRid);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.datasetRids.hashCode();
        h += (h << 5) + Objects.hashCode(this.lsdHash);
        h += (h << 5) + Objects.hashCode(this.lsdHashWithMetadataScrubbed);
        h += (h << 5) + Objects.hashCode(this.lsdHashWithDatasetAndMetadataScrubbed);
        h += (h << 5) + Objects.hashCode(this.unresolvedLsdHash);
        h += (h << 5) + Objects.hashCode(this.unresolvedLsdHashWithMetadataScrubbed);
        h += (h << 5) + Objects.hashCode(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SourceMetadata{");
        if (this.graphId != null) {
            builder.append("graphId=").append(this.graphId);
        }
        if (this.nodeId != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("nodeId=").append(this.nodeId);
        }
        if (this.refRid != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("refRid=").append(this.refRid);
        }
        if (this.refParentRid != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("refParentRid=").append(this.refParentRid);
        }
        if (this.sourceId != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("sourceId=").append(this.sourceId);
        }
        if (this.sparkReporterOwningRid != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("sparkReporterOwningRid=").append(this.sparkReporterOwningRid);
        }
        if (this.resourceManagementAttributionRid != null) {
            if (builder.length() > 15) {
                builder.append(", ");
            }
            builder.append("resourceManagementAttributionRid=").append(this.resourceManagementAttributionRid);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("datasetRids=").append(this.datasetRids);
        if (this.lsdHash != null) {
            builder.append(", ");
            builder.append("lsdHash=").append(this.lsdHash);
        }
        if (this.lsdHashWithMetadataScrubbed != null) {
            builder.append(", ");
            builder.append("lsdHashWithMetadataScrubbed=").append(this.lsdHashWithMetadataScrubbed);
        }
        if (this.lsdHashWithDatasetAndMetadataScrubbed != null) {
            builder.append(", ");
            builder.append("lsdHashWithDatasetAndMetadataScrubbed=").append(this.lsdHashWithDatasetAndMetadataScrubbed);
        }
        if (this.unresolvedLsdHash != null) {
            builder.append(", ");
            builder.append("unresolvedLsdHash=").append(this.unresolvedLsdHash);
        }
        if (this.unresolvedLsdHashWithMetadataScrubbed != null) {
            builder.append(", ");
            builder.append("unresolvedLsdHashWithMetadataScrubbed=").append(this.unresolvedLsdHashWithMetadataScrubbed);
        }
        if (this.unresolvedLsdHashWithDatasetAndMetadataScrubbed != null) {
            builder.append(", ");
            builder.append("unresolvedLsdHashWithDatasetAndMetadataScrubbed=").append(this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSourceMetadata fromJson(Json json) {
        SourceMetadata.Builder builder = new SourceMetadata.Builder();
        if (json.graphId != null) {
            builder.graphId(json.graphId);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.refRid != null) {
            builder.refRid(json.refRid);
        }
        if (json.refParentRid != null) {
            builder.refParentRid(json.refParentRid);
        }
        if (json.sourceId != null) {
            builder.sourceId(json.sourceId);
        }
        if (json.sparkReporterOwningRid != null) {
            builder.sparkReporterOwningRid(json.sparkReporterOwningRid);
        }
        if (json.resourceManagementAttributionRid != null) {
            builder.resourceManagementAttributionRid(json.resourceManagementAttributionRid);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.datasetRids != null) {
            builder.addAllDatasetRids(json.datasetRids);
        }
        if (json.lsdHash != null) {
            builder.lsdHash(json.lsdHash);
        }
        if (json.lsdHashWithMetadataScrubbed != null) {
            builder.lsdHashWithMetadataScrubbed(json.lsdHashWithMetadataScrubbed);
        }
        if (json.lsdHashWithDatasetAndMetadataScrubbed != null) {
            builder.lsdHashWithDatasetAndMetadataScrubbed(json.lsdHashWithDatasetAndMetadataScrubbed);
        }
        if (json.unresolvedLsdHash != null) {
            builder.unresolvedLsdHash(json.unresolvedLsdHash);
        }
        if (json.unresolvedLsdHashWithMetadataScrubbed != null) {
            builder.unresolvedLsdHashWithMetadataScrubbed(json.unresolvedLsdHashWithMetadataScrubbed);
        }
        if (json.unresolvedLsdHashWithDatasetAndMetadataScrubbed != null) {
            builder.unresolvedLsdHashWithDatasetAndMetadataScrubbed(json.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
        }
        return builder.build();
    }

    public static ImmutableSourceMetadata copyOf(SourceMetadata instance) {
        if (instance instanceof ImmutableSourceMetadata) {
            return (ImmutableSourceMetadata)instance;
        }
        return new SourceMetadata.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="SourceMetadata", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String graphId;
        @Nullable
        private String nodeId;
        @Nullable
        private String refRid;
        @Nullable
        private ResourceIdentifier refParentRid;
        @Nullable
        private String sourceId;
        @Nullable
        private ResourceIdentifier sparkReporterOwningRid;
        @Nullable
        private ResourceIdentifier resourceManagementAttributionRid;
        @Nullable
        private UserId userId;
        private List<ResourceIdentifier> datasetRids = new ArrayList<ResourceIdentifier>();
        @Nullable
        private String lsdHash;
        @Nullable
        private String lsdHashWithMetadataScrubbed;
        @Nullable
        private String lsdHashWithDatasetAndMetadataScrubbed;
        @Nullable
        private String unresolvedLsdHash;
        @Nullable
        private String unresolvedLsdHashWithMetadataScrubbed;
        @Nullable
        private String unresolvedLsdHashWithDatasetAndMetadataScrubbed;

        public Builder() {
            if (!(this instanceof SourceMetadata.Builder)) {
                throw new UnsupportedOperationException("Use: new SourceMetadata.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder from(SourceMetadata instance) {
            Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbedOptional;
            Optional<String> unresolvedLsdHashWithMetadataScrubbedOptional;
            Optional<String> unresolvedLsdHashOptional;
            Optional<String> lsdHashWithDatasetAndMetadataScrubbedOptional;
            Optional<String> lsdHashWithMetadataScrubbedOptional;
            Optional<ResourceIdentifier> resourceManagementAttributionRidOptional;
            Optional<ResourceIdentifier> sparkReporterOwningRidOptional;
            Optional<String> sourceIdOptional;
            Optional<ResourceIdentifier> refParentRidOptional;
            Optional<String> refRidOptional;
            Optional<String> nodeIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> graphIdOptional = instance.graphId();
            if (graphIdOptional.isPresent()) {
                this.graphId(graphIdOptional);
            }
            if ((nodeIdOptional = instance.nodeId()).isPresent()) {
                this.nodeId(nodeIdOptional);
            }
            if ((refRidOptional = instance.refRid()).isPresent()) {
                this.refRid(refRidOptional);
            }
            if ((refParentRidOptional = instance.refParentRid()).isPresent()) {
                this.refParentRid(refParentRidOptional);
            }
            if ((sourceIdOptional = instance.sourceId()).isPresent()) {
                this.sourceId(sourceIdOptional);
            }
            if ((sparkReporterOwningRidOptional = instance.sparkReporterOwningRid()).isPresent()) {
                this.sparkReporterOwningRid(sparkReporterOwningRidOptional);
            }
            if ((resourceManagementAttributionRidOptional = instance.resourceManagementAttributionRid()).isPresent()) {
                this.resourceManagementAttributionRid(resourceManagementAttributionRidOptional);
            }
            this.userId(instance.userId());
            this.addAllDatasetRids(instance.datasetRids());
            Optional<String> lsdHashOptional = instance.lsdHash();
            if (lsdHashOptional.isPresent()) {
                this.lsdHash(lsdHashOptional);
            }
            if ((lsdHashWithMetadataScrubbedOptional = instance.lsdHashWithMetadataScrubbed()).isPresent()) {
                this.lsdHashWithMetadataScrubbed(lsdHashWithMetadataScrubbedOptional);
            }
            if ((lsdHashWithDatasetAndMetadataScrubbedOptional = instance.lsdHashWithDatasetAndMetadataScrubbed()).isPresent()) {
                this.lsdHashWithDatasetAndMetadataScrubbed(lsdHashWithDatasetAndMetadataScrubbedOptional);
            }
            if ((unresolvedLsdHashOptional = instance.unresolvedLsdHash()).isPresent()) {
                this.unresolvedLsdHash(unresolvedLsdHashOptional);
            }
            if ((unresolvedLsdHashWithMetadataScrubbedOptional = instance.unresolvedLsdHashWithMetadataScrubbed()).isPresent()) {
                this.unresolvedLsdHashWithMetadataScrubbed(unresolvedLsdHashWithMetadataScrubbedOptional);
            }
            if ((unresolvedLsdHashWithDatasetAndMetadataScrubbedOptional = instance.unresolvedLsdHashWithDatasetAndMetadataScrubbed()).isPresent()) {
                this.unresolvedLsdHashWithDatasetAndMetadataScrubbed(unresolvedLsdHashWithDatasetAndMetadataScrubbedOptional);
            }
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder graphId(String graphId) {
            this.graphId = Objects.requireNonNull(graphId, "graphId");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="graphId")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder graphId(Optional<String> graphId) {
            this.graphId = graphId.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="nodeId")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder nodeId(Optional<String> nodeId) {
            this.nodeId = nodeId.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder refRid(String refRid) {
            this.refRid = Objects.requireNonNull(refRid, "refRid");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="refRid")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder refRid(Optional<String> refRid) {
            this.refRid = refRid.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder refParentRid(ResourceIdentifier refParentRid) {
            this.refParentRid = Objects.requireNonNull(refParentRid, "refParentRid");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="refParentRid")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder refParentRid(Optional<? extends ResourceIdentifier> refParentRid) {
            this.refParentRid = refParentRid.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder sourceId(String sourceId) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="sourceId")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder sourceId(Optional<String> sourceId) {
            this.sourceId = sourceId.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder sparkReporterOwningRid(ResourceIdentifier sparkReporterOwningRid) {
            this.sparkReporterOwningRid = Objects.requireNonNull(sparkReporterOwningRid, "sparkReporterOwningRid");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="sparkReporterOwningRid")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder sparkReporterOwningRid(Optional<? extends ResourceIdentifier> sparkReporterOwningRid) {
            this.sparkReporterOwningRid = sparkReporterOwningRid.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder resourceManagementAttributionRid(ResourceIdentifier resourceManagementAttributionRid) {
            this.resourceManagementAttributionRid = Objects.requireNonNull(resourceManagementAttributionRid, "resourceManagementAttributionRid");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="resourceManagementAttributionRid")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder resourceManagementAttributionRid(Optional<? extends ResourceIdentifier> resourceManagementAttributionRid) {
            this.resourceManagementAttributionRid = resourceManagementAttributionRid.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="userId")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder userId(UserId userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder addDatasetRids(ResourceIdentifier element) {
            this.datasetRids.add(Objects.requireNonNull(element, "datasetRids element"));
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder addDatasetRids(ResourceIdentifier ... elements) {
            for (ResourceIdentifier element : elements) {
                this.datasetRids.add(Objects.requireNonNull(element, "datasetRids element"));
            }
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="datasetRids")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder datasetRids(Iterable<? extends ResourceIdentifier> elements) {
            this.datasetRids.clear();
            return this.addAllDatasetRids(elements);
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder addAllDatasetRids(Iterable<? extends ResourceIdentifier> elements) {
            for (ResourceIdentifier resourceIdentifier : elements) {
                this.datasetRids.add(Objects.requireNonNull(resourceIdentifier, "datasetRids element"));
            }
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHash(String lsdHash) {
            this.lsdHash = Objects.requireNonNull(lsdHash, "lsdHash");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="lsdHash")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHash(Optional<String> lsdHash) {
            this.lsdHash = lsdHash.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHashWithMetadataScrubbed(String lsdHashWithMetadataScrubbed) {
            this.lsdHashWithMetadataScrubbed = Objects.requireNonNull(lsdHashWithMetadataScrubbed, "lsdHashWithMetadataScrubbed");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="lsdHashWithMetadataScrubbed")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHashWithMetadataScrubbed(Optional<String> lsdHashWithMetadataScrubbed) {
            this.lsdHashWithMetadataScrubbed = lsdHashWithMetadataScrubbed.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHashWithDatasetAndMetadataScrubbed(String lsdHashWithDatasetAndMetadataScrubbed) {
            this.lsdHashWithDatasetAndMetadataScrubbed = Objects.requireNonNull(lsdHashWithDatasetAndMetadataScrubbed, "lsdHashWithDatasetAndMetadataScrubbed");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="lsdHashWithDatasetAndMetadataScrubbed")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder lsdHashWithDatasetAndMetadataScrubbed(Optional<String> lsdHashWithDatasetAndMetadataScrubbed) {
            this.lsdHashWithDatasetAndMetadataScrubbed = lsdHashWithDatasetAndMetadataScrubbed.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHash(String unresolvedLsdHash) {
            this.unresolvedLsdHash = Objects.requireNonNull(unresolvedLsdHash, "unresolvedLsdHash");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="unresolvedLsdHash")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHash(Optional<String> unresolvedLsdHash) {
            this.unresolvedLsdHash = unresolvedLsdHash.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHashWithMetadataScrubbed(String unresolvedLsdHashWithMetadataScrubbed) {
            this.unresolvedLsdHashWithMetadataScrubbed = Objects.requireNonNull(unresolvedLsdHashWithMetadataScrubbed, "unresolvedLsdHashWithMetadataScrubbed");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="unresolvedLsdHashWithMetadataScrubbed")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHashWithMetadataScrubbed(Optional<String> unresolvedLsdHashWithMetadataScrubbed) {
            this.unresolvedLsdHashWithMetadataScrubbed = unresolvedLsdHashWithMetadataScrubbed.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHashWithDatasetAndMetadataScrubbed(String unresolvedLsdHashWithDatasetAndMetadataScrubbed) {
            this.unresolvedLsdHashWithDatasetAndMetadataScrubbed = Objects.requireNonNull(unresolvedLsdHashWithDatasetAndMetadataScrubbed, "unresolvedLsdHashWithDatasetAndMetadataScrubbed");
            return (SourceMetadata.Builder)this;
        }

        @JsonProperty(value="unresolvedLsdHashWithDatasetAndMetadataScrubbed")
        @CanIgnoreReturnValue
        public final SourceMetadata.Builder unresolvedLsdHashWithDatasetAndMetadataScrubbed(Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbed) {
            this.unresolvedLsdHashWithDatasetAndMetadataScrubbed = unresolvedLsdHashWithDatasetAndMetadataScrubbed.orElse(null);
            return (SourceMetadata.Builder)this;
        }

        public ImmutableSourceMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSourceMetadata(this.graphId, this.nodeId, this.refRid, this.refParentRid, this.sourceId, this.sparkReporterOwningRid, this.resourceManagementAttributionRid, this.userId, ImmutableSourceMetadata.createUnmodifiableSet(this.datasetRids), this.lsdHash, this.lsdHashWithMetadataScrubbed, this.lsdHashWithDatasetAndMetadataScrubbed, this.unresolvedLsdHash, this.unresolvedLsdHashWithMetadataScrubbed, this.unresolvedLsdHashWithDatasetAndMetadataScrubbed);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build SourceMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SourceMetadata", generator="Immutables")
    static final class Json
    implements SourceMetadata {
        @Nullable
        Optional<String> graphId = Optional.empty();
        @Nullable
        Optional<String> nodeId = Optional.empty();
        @Nullable
        Optional<String> refRid = Optional.empty();
        @Nullable
        Optional<ResourceIdentifier> refParentRid = Optional.empty();
        @Nullable
        Optional<String> sourceId = Optional.empty();
        @Nullable
        Optional<ResourceIdentifier> sparkReporterOwningRid = Optional.empty();
        @Nullable
        Optional<ResourceIdentifier> resourceManagementAttributionRid = Optional.empty();
        @Nullable
        UserId userId;
        @Nullable
        Set<ResourceIdentifier> datasetRids = Collections.emptySet();
        @Nullable
        Optional<String> lsdHash = Optional.empty();
        @Nullable
        Optional<String> lsdHashWithMetadataScrubbed = Optional.empty();
        @Nullable
        Optional<String> lsdHashWithDatasetAndMetadataScrubbed = Optional.empty();
        @Nullable
        Optional<String> unresolvedLsdHash = Optional.empty();
        @Nullable
        Optional<String> unresolvedLsdHashWithMetadataScrubbed = Optional.empty();
        @Nullable
        Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbed = Optional.empty();

        Json() {
        }

        @JsonProperty(value="graphId")
        public void setGraphId(Optional<String> graphId) {
            this.graphId = graphId;
        }

        @JsonProperty(value="nodeId")
        public void setNodeId(Optional<String> nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty(value="refRid")
        public void setRefRid(Optional<String> refRid) {
            this.refRid = refRid;
        }

        @JsonProperty(value="refParentRid")
        public void setRefParentRid(Optional<ResourceIdentifier> refParentRid) {
            this.refParentRid = refParentRid;
        }

        @JsonProperty(value="sourceId")
        public void setSourceId(Optional<String> sourceId) {
            this.sourceId = sourceId;
        }

        @JsonProperty(value="sparkReporterOwningRid")
        public void setSparkReporterOwningRid(Optional<ResourceIdentifier> sparkReporterOwningRid) {
            this.sparkReporterOwningRid = sparkReporterOwningRid;
        }

        @JsonProperty(value="resourceManagementAttributionRid")
        public void setResourceManagementAttributionRid(Optional<ResourceIdentifier> resourceManagementAttributionRid) {
            this.resourceManagementAttributionRid = resourceManagementAttributionRid;
        }

        @JsonProperty(value="userId")
        public void setUserId(UserId userId) {
            this.userId = userId;
        }

        @JsonProperty(value="datasetRids")
        public void setDatasetRids(Set<ResourceIdentifier> datasetRids) {
            this.datasetRids = datasetRids;
        }

        @JsonProperty(value="lsdHash")
        public void setLsdHash(Optional<String> lsdHash) {
            this.lsdHash = lsdHash;
        }

        @JsonProperty(value="lsdHashWithMetadataScrubbed")
        public void setLsdHashWithMetadataScrubbed(Optional<String> lsdHashWithMetadataScrubbed) {
            this.lsdHashWithMetadataScrubbed = lsdHashWithMetadataScrubbed;
        }

        @JsonProperty(value="lsdHashWithDatasetAndMetadataScrubbed")
        public void setLsdHashWithDatasetAndMetadataScrubbed(Optional<String> lsdHashWithDatasetAndMetadataScrubbed) {
            this.lsdHashWithDatasetAndMetadataScrubbed = lsdHashWithDatasetAndMetadataScrubbed;
        }

        @JsonProperty(value="unresolvedLsdHash")
        public void setUnresolvedLsdHash(Optional<String> unresolvedLsdHash) {
            this.unresolvedLsdHash = unresolvedLsdHash;
        }

        @JsonProperty(value="unresolvedLsdHashWithMetadataScrubbed")
        public void setUnresolvedLsdHashWithMetadataScrubbed(Optional<String> unresolvedLsdHashWithMetadataScrubbed) {
            this.unresolvedLsdHashWithMetadataScrubbed = unresolvedLsdHashWithMetadataScrubbed;
        }

        @JsonProperty(value="unresolvedLsdHashWithDatasetAndMetadataScrubbed")
        public void setUnresolvedLsdHashWithDatasetAndMetadataScrubbed(Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbed) {
            this.unresolvedLsdHashWithDatasetAndMetadataScrubbed = unresolvedLsdHashWithDatasetAndMetadataScrubbed;
        }

        @Override
        public Optional<String> graphId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> refRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResourceIdentifier> refParentRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> sourceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResourceIdentifier> sparkReporterOwningRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResourceIdentifier> resourceManagementAttributionRid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserId userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ResourceIdentifier> datasetRids() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lsdHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lsdHashWithMetadataScrubbed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lsdHashWithDatasetAndMetadataScrubbed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> unresolvedLsdHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> unresolvedLsdHashWithMetadataScrubbed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> unresolvedLsdHashWithDatasetAndMetadataScrubbed() {
            throw new UnsupportedOperationException();
        }
    }
}

