/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import latitude.api.parameters.DatasetEnumerationInfo;
import latitude.api.parameters.LocalParameterInfo;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterType;
import latitude.api.parameters.RestrictedViewEnumerationInfo;
import latitude.api.parameters.TableEnumerationInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="LocalParameterInfo", generator="Immutables")
@Immutable
final class ImmutableLocalParameterInfo
implements LocalParameterInfo {
    private final ParameterId id;
    private final String name;
    @Nullable
    private final String description;
    private final Object defaultValue;
    private final ParameterType type;
    private final boolean allowMultipleValues;
    private final boolean usesMultipleValues;
    private final boolean hideInDashboard;
    @Nullable
    private final DatasetEnumerationInfo enumerationInfo;
    @Nullable
    private final RestrictedViewEnumerationInfo restrictedViewEnumerationInfo;
    @Nullable
    private final TableEnumerationInfo tableEnumerationInfo;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLocalParameterInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
        this.enumerationInfo = builder.enumerationInfo;
        this.restrictedViewEnumerationInfo = builder.restrictedViewEnumerationInfo;
        this.tableEnumerationInfo = builder.tableEnumerationInfo;
        if (builder.allowMultipleValuesIsSet()) {
            this.initShim.allowMultipleValues(builder.allowMultipleValues);
        }
        if (builder.usesMultipleValuesIsSet()) {
            this.initShim.usesMultipleValues(builder.usesMultipleValues);
        }
        if (builder.hideInDashboardIsSet()) {
            this.initShim.hideInDashboard(builder.hideInDashboard);
        }
        this.allowMultipleValues = this.initShim.allowMultipleValues();
        this.usesMultipleValues = this.initShim.usesMultipleValues();
        this.hideInDashboard = this.initShim.hideInDashboard();
        this.initShim = null;
    }

    private ImmutableLocalParameterInfo(ParameterId id, String name, @Nullable String description, Object defaultValue, ParameterType type, boolean allowMultipleValues, boolean usesMultipleValues, boolean hideInDashboard, @Nullable DatasetEnumerationInfo enumerationInfo, @Nullable RestrictedViewEnumerationInfo restrictedViewEnumerationInfo, @Nullable TableEnumerationInfo tableEnumerationInfo) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.allowMultipleValues = allowMultipleValues;
        this.usesMultipleValues = usesMultipleValues;
        this.hideInDashboard = hideInDashboard;
        this.enumerationInfo = enumerationInfo;
        this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo;
        this.tableEnumerationInfo = tableEnumerationInfo;
        this.initShim = null;
    }

    private boolean allowMultipleValuesInitialize() {
        return LocalParameterInfo.super.allowMultipleValues();
    }

    private boolean usesMultipleValuesInitialize() {
        return LocalParameterInfo.super.usesMultipleValues();
    }

    private boolean hideInDashboardInitialize() {
        return LocalParameterInfo.super.hideInDashboard();
    }

    @Override
    @JsonProperty(value="id")
    public ParameterId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="defaultValue")
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty(value="type")
    public ParameterType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="allowMultipleValues")
    public boolean allowMultipleValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowMultipleValues() : this.allowMultipleValues;
    }

    @Override
    @JsonProperty(value="usesMultipleValues")
    public boolean usesMultipleValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usesMultipleValues() : this.usesMultipleValues;
    }

    @Override
    @JsonProperty(value="hideInDashboard")
    public boolean hideInDashboard() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hideInDashboard() : this.hideInDashboard;
    }

    @Override
    @JsonProperty(value="enumerationInfo")
    public Optional<DatasetEnumerationInfo> enumerationInfo() {
        return Optional.ofNullable(this.enumerationInfo);
    }

    @Override
    @JsonProperty(value="restrictedViewEnumerationInfo")
    public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo() {
        return Optional.ofNullable(this.restrictedViewEnumerationInfo);
    }

    @Override
    @JsonProperty(value="tableEnumerationInfo")
    public Optional<TableEnumerationInfo> tableEnumerationInfo() {
        return Optional.ofNullable(this.tableEnumerationInfo);
    }

    public final ImmutableLocalParameterInfo withId(ParameterId value) {
        if (this.id == value) {
            return this;
        }
        ParameterId newValue = Objects.requireNonNull(value, "id");
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(newValue, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, newValue, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, newValue, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, value, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withDefaultValue(Object value) {
        if (this.defaultValue == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "defaultValue");
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, newValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withType(ParameterType value) {
        ParameterType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, newValue, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withAllowMultipleValues(boolean value) {
        if (this.allowMultipleValues == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, value, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withUsesMultipleValues(boolean value) {
        if (this.usesMultipleValues == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, value, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withHideInDashboard(boolean value) {
        if (this.hideInDashboard == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, value, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withEnumerationInfo(DatasetEnumerationInfo value) {
        DatasetEnumerationInfo newValue = Objects.requireNonNull(value, "enumerationInfo");
        if (this.enumerationInfo == newValue) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, newValue, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withEnumerationInfo(Optional<? extends DatasetEnumerationInfo> optional) {
        DatasetEnumerationInfo value = optional.orElse(null);
        if (this.enumerationInfo == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, value, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withRestrictedViewEnumerationInfo(RestrictedViewEnumerationInfo value) {
        RestrictedViewEnumerationInfo newValue = Objects.requireNonNull(value, "restrictedViewEnumerationInfo");
        if (this.restrictedViewEnumerationInfo == newValue) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, newValue, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withRestrictedViewEnumerationInfo(Optional<? extends RestrictedViewEnumerationInfo> optional) {
        RestrictedViewEnumerationInfo value = optional.orElse(null);
        if (this.restrictedViewEnumerationInfo == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, value, this.tableEnumerationInfo));
    }

    public final ImmutableLocalParameterInfo withTableEnumerationInfo(TableEnumerationInfo value) {
        TableEnumerationInfo newValue = Objects.requireNonNull(value, "tableEnumerationInfo");
        if (this.tableEnumerationInfo == newValue) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, newValue));
    }

    public final ImmutableLocalParameterInfo withTableEnumerationInfo(Optional<? extends TableEnumerationInfo> optional) {
        TableEnumerationInfo value = optional.orElse(null);
        if (this.tableEnumerationInfo == value) {
            return this;
        }
        return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this.id, this.name, this.description, this.defaultValue, this.type, this.allowMultipleValues, this.usesMultipleValues, this.hideInDashboard, this.enumerationInfo, this.restrictedViewEnumerationInfo, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocalParameterInfo && this.equalTo(0, (ImmutableLocalParameterInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableLocalParameterInfo another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.description, another.description) && this.defaultValue.equals(another.defaultValue) && this.type.equals((Object)another.type) && this.allowMultipleValues == another.allowMultipleValues && this.usesMultipleValues == another.usesMultipleValues && this.hideInDashboard == another.hideInDashboard && Objects.equals(this.enumerationInfo, another.enumerationInfo) && Objects.equals(this.restrictedViewEnumerationInfo, another.restrictedViewEnumerationInfo) && Objects.equals(this.tableEnumerationInfo, another.tableEnumerationInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Boolean.hashCode(this.allowMultipleValues);
        h += (h << 5) + Boolean.hashCode(this.usesMultipleValues);
        h += (h << 5) + Boolean.hashCode(this.hideInDashboard);
        h += (h << 5) + Objects.hashCode(this.enumerationInfo);
        h += (h << 5) + Objects.hashCode(this.restrictedViewEnumerationInfo);
        h += (h << 5) + Objects.hashCode(this.tableEnumerationInfo);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LocalParameterInfo{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("defaultValue=").append(this.defaultValue);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("allowMultipleValues=").append(this.allowMultipleValues);
        builder.append(", ");
        builder.append("usesMultipleValues=").append(this.usesMultipleValues);
        builder.append(", ");
        builder.append("hideInDashboard=").append(this.hideInDashboard);
        if (this.enumerationInfo != null) {
            builder.append(", ");
            builder.append("enumerationInfo=").append(this.enumerationInfo);
        }
        if (this.restrictedViewEnumerationInfo != null) {
            builder.append(", ");
            builder.append("restrictedViewEnumerationInfo=").append(this.restrictedViewEnumerationInfo);
        }
        if (this.tableEnumerationInfo != null) {
            builder.append(", ");
            builder.append("tableEnumerationInfo=").append(this.tableEnumerationInfo);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocalParameterInfo fromJson(Json json) {
        LocalParameterInfo.Builder builder = new LocalParameterInfo.Builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.defaultValue != null) {
            builder.defaultValue(json.defaultValue);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.allowMultipleValuesIsSet) {
            builder.allowMultipleValues(json.allowMultipleValues);
        }
        if (json.usesMultipleValuesIsSet) {
            builder.usesMultipleValues(json.usesMultipleValues);
        }
        if (json.hideInDashboardIsSet) {
            builder.hideInDashboard(json.hideInDashboard);
        }
        if (json.enumerationInfo != null) {
            builder.enumerationInfo(json.enumerationInfo);
        }
        if (json.restrictedViewEnumerationInfo != null) {
            builder.restrictedViewEnumerationInfo(json.restrictedViewEnumerationInfo);
        }
        if (json.tableEnumerationInfo != null) {
            builder.tableEnumerationInfo(json.tableEnumerationInfo);
        }
        return builder.build();
    }

    private static ImmutableLocalParameterInfo validate(ImmutableLocalParameterInfo instance) {
        instance.check();
        return instance;
    }

    public static ImmutableLocalParameterInfo copyOf(LocalParameterInfo instance) {
        if (instance instanceof ImmutableLocalParameterInfo) {
            return (ImmutableLocalParameterInfo)instance;
        }
        return new LocalParameterInfo.Builder().from(instance).build();
    }

    @Generated(from="LocalParameterInfo", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DEFAULT_VALUE = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long OPT_BIT_ALLOW_MULTIPLE_VALUES = 1L;
        private static final long OPT_BIT_USES_MULTIPLE_VALUES = 2L;
        private static final long OPT_BIT_HIDE_IN_DASHBOARD = 4L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private ParameterId id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private Object defaultValue;
        @Nullable
        private ParameterType type;
        private boolean allowMultipleValues;
        private boolean usesMultipleValues;
        private boolean hideInDashboard;
        @Nullable
        private DatasetEnumerationInfo enumerationInfo;
        @Nullable
        private RestrictedViewEnumerationInfo restrictedViewEnumerationInfo;
        @Nullable
        private TableEnumerationInfo tableEnumerationInfo;

        public Builder() {
            if (!(this instanceof LocalParameterInfo.Builder)) {
                throw new UnsupportedOperationException("Use: new LocalParameterInfo.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder from(LocalParameterInfo instance) {
            Optional<TableEnumerationInfo> tableEnumerationInfoOptional;
            Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfoOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            this.defaultValue(instance.defaultValue());
            this.type(instance.type());
            this.allowMultipleValues(instance.allowMultipleValues());
            this.usesMultipleValues(instance.usesMultipleValues());
            this.hideInDashboard(instance.hideInDashboard());
            Optional<DatasetEnumerationInfo> enumerationInfoOptional = instance.enumerationInfo();
            if (enumerationInfoOptional.isPresent()) {
                this.enumerationInfo(enumerationInfoOptional);
            }
            if ((restrictedViewEnumerationInfoOptional = instance.restrictedViewEnumerationInfo()).isPresent()) {
                this.restrictedViewEnumerationInfo(restrictedViewEnumerationInfoOptional);
            }
            if ((tableEnumerationInfoOptional = instance.tableEnumerationInfo()).isPresent()) {
                this.tableEnumerationInfo(tableEnumerationInfoOptional);
            }
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder id(ParameterId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (LocalParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="defaultValue")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder defaultValue(Object defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder type(ParameterType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="allowMultipleValues")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder allowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.optBits |= 1L;
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="usesMultipleValues")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder usesMultipleValues(boolean usesMultipleValues) {
            this.usesMultipleValues = usesMultipleValues;
            this.optBits |= 2L;
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="hideInDashboard")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder hideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.optBits |= 4L;
            return (LocalParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder enumerationInfo(DatasetEnumerationInfo enumerationInfo) {
            this.enumerationInfo = Objects.requireNonNull(enumerationInfo, "enumerationInfo");
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="enumerationInfo")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder enumerationInfo(Optional<? extends DatasetEnumerationInfo> enumerationInfo) {
            this.enumerationInfo = enumerationInfo.orElse(null);
            return (LocalParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder restrictedViewEnumerationInfo(RestrictedViewEnumerationInfo restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = Objects.requireNonNull(restrictedViewEnumerationInfo, "restrictedViewEnumerationInfo");
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="restrictedViewEnumerationInfo")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder restrictedViewEnumerationInfo(Optional<? extends RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo.orElse(null);
            return (LocalParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder tableEnumerationInfo(TableEnumerationInfo tableEnumerationInfo) {
            this.tableEnumerationInfo = Objects.requireNonNull(tableEnumerationInfo, "tableEnumerationInfo");
            return (LocalParameterInfo.Builder)this;
        }

        @JsonProperty(value="tableEnumerationInfo")
        @CanIgnoreReturnValue
        public final LocalParameterInfo.Builder tableEnumerationInfo(Optional<? extends TableEnumerationInfo> tableEnumerationInfo) {
            this.tableEnumerationInfo = tableEnumerationInfo.orElse(null);
            return (LocalParameterInfo.Builder)this;
        }

        public ImmutableLocalParameterInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLocalParameterInfo.validate(new ImmutableLocalParameterInfo(this));
        }

        private boolean allowMultipleValuesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean usesMultipleValuesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hideInDashboardIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build LocalParameterInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LocalParameterInfo", generator="Immutables")
    static final class Json
    implements LocalParameterInfo {
        @Nullable
        ParameterId id;
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Object defaultValue;
        @Nullable
        ParameterType type;
        boolean allowMultipleValues;
        boolean allowMultipleValuesIsSet;
        boolean usesMultipleValues;
        boolean usesMultipleValuesIsSet;
        boolean hideInDashboard;
        boolean hideInDashboardIsSet;
        @Nullable
        Optional<DatasetEnumerationInfo> enumerationInfo = Optional.empty();
        @Nullable
        Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo = Optional.empty();
        @Nullable
        Optional<TableEnumerationInfo> tableEnumerationInfo = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(ParameterId id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="defaultValue")
        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @JsonProperty(value="type")
        public void setType(ParameterType type) {
            this.type = type;
        }

        @JsonProperty(value="allowMultipleValues")
        public void setAllowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.allowMultipleValuesIsSet = true;
        }

        @JsonProperty(value="usesMultipleValues")
        public void setUsesMultipleValues(boolean usesMultipleValues) {
            this.usesMultipleValues = usesMultipleValues;
            this.usesMultipleValuesIsSet = true;
        }

        @JsonProperty(value="hideInDashboard")
        public void setHideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.hideInDashboardIsSet = true;
        }

        @JsonProperty(value="enumerationInfo")
        public void setEnumerationInfo(Optional<DatasetEnumerationInfo> enumerationInfo) {
            this.enumerationInfo = enumerationInfo;
        }

        @JsonProperty(value="restrictedViewEnumerationInfo")
        public void setRestrictedViewEnumerationInfo(Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo;
        }

        @JsonProperty(value="tableEnumerationInfo")
        public void setTableEnumerationInfo(Optional<TableEnumerationInfo> tableEnumerationInfo) {
            this.tableEnumerationInfo = tableEnumerationInfo;
        }

        @Override
        public ParameterId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object defaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ParameterType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean allowMultipleValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean usesMultipleValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hideInDashboard() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DatasetEnumerationInfo> enumerationInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TableEnumerationInfo> tableEnumerationInfo() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="LocalParameterInfo", generator="Immutables")
    private final class InitShim {
        private byte allowMultipleValuesBuildStage = 0;
        private boolean allowMultipleValues;
        private byte usesMultipleValuesBuildStage = 0;
        private boolean usesMultipleValues;
        private byte hideInDashboardBuildStage = 0;
        private boolean hideInDashboard;

        private InitShim() {
        }

        boolean allowMultipleValues() {
            if (this.allowMultipleValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowMultipleValuesBuildStage == 0) {
                this.allowMultipleValuesBuildStage = (byte)-1;
                this.allowMultipleValues = ImmutableLocalParameterInfo.this.allowMultipleValuesInitialize();
                this.allowMultipleValuesBuildStage = 1;
            }
            return this.allowMultipleValues;
        }

        void allowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.allowMultipleValuesBuildStage = 1;
        }

        boolean usesMultipleValues() {
            if (this.usesMultipleValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usesMultipleValuesBuildStage == 0) {
                this.usesMultipleValuesBuildStage = (byte)-1;
                this.usesMultipleValues = ImmutableLocalParameterInfo.this.usesMultipleValuesInitialize();
                this.usesMultipleValuesBuildStage = 1;
            }
            return this.usesMultipleValues;
        }

        void usesMultipleValues(boolean usesMultipleValues) {
            this.usesMultipleValues = usesMultipleValues;
            this.usesMultipleValuesBuildStage = 1;
        }

        boolean hideInDashboard() {
            if (this.hideInDashboardBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hideInDashboardBuildStage == 0) {
                this.hideInDashboardBuildStage = (byte)-1;
                this.hideInDashboard = ImmutableLocalParameterInfo.this.hideInDashboardInitialize();
                this.hideInDashboardBuildStage = 1;
            }
            return this.hideInDashboard;
        }

        void hideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.hideInDashboardBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allowMultipleValuesBuildStage == -1) {
                attributes.add("allowMultipleValues");
            }
            if (this.usesMultipleValuesBuildStage == -1) {
                attributes.add("usesMultipleValues");
            }
            if (this.hideInDashboardBuildStage == -1) {
                attributes.add("hideInDashboard");
            }
            return "Cannot build LocalParameterInfo, attribute initializers form cycle " + attributes;
        }
    }
}

