/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import latitude.api.parameters.DatasetEnumerationInfo;
import latitude.api.parameters.ParameterDefaultValue;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterInfo;
import latitude.api.parameters.ParameterType;
import latitude.api.parameters.RestrictedViewEnumerationInfo;
import latitude.api.parameters.TableEnumerationInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParameterInfo", generator="Immutables")
@Immutable
final class ImmutableParameterInfo
implements ParameterInfo {
    private final ParameterId id;
    private final String name;
    @Nullable
    private final String displayName;
    @Nullable
    private final String description;
    private final Object defaultValue;
    @Nullable
    private final ParameterDefaultValue defaultValueV1;
    private final ParameterType type;
    private final boolean allowMultipleValues;
    private final boolean hideInDashboard;
    private final boolean isMandatory;
    private final boolean suggestedValuesOnly;
    @Nullable
    private final DatasetEnumerationInfo enumerationInfo;
    @Nullable
    private final RestrictedViewEnumerationInfo restrictedViewEnumerationInfo;
    @Nullable
    private final TableEnumerationInfo tableEnumerationInfo;
    private final List<String> manualEnumeration;
    private final boolean active;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableParameterInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.defaultValueV1 = builder.defaultValueV1;
        this.type = builder.type;
        this.enumerationInfo = builder.enumerationInfo;
        this.restrictedViewEnumerationInfo = builder.restrictedViewEnumerationInfo;
        this.tableEnumerationInfo = builder.tableEnumerationInfo;
        this.manualEnumeration = ImmutableParameterInfo.createUnmodifiableList(true, builder.manualEnumeration);
        this.active = builder.active;
        if (builder.allowMultipleValuesIsSet()) {
            this.initShim.allowMultipleValues(builder.allowMultipleValues);
        }
        if (builder.hideInDashboardIsSet()) {
            this.initShim.hideInDashboard(builder.hideInDashboard);
        }
        if (builder.isMandatoryIsSet()) {
            this.initShim.isMandatory(builder.isMandatory);
        }
        if (builder.suggestedValuesOnlyIsSet()) {
            this.initShim.suggestedValuesOnly(builder.suggestedValuesOnly);
        }
        this.allowMultipleValues = this.initShim.allowMultipleValues();
        this.hideInDashboard = this.initShim.hideInDashboard();
        this.isMandatory = this.initShim.isMandatory();
        this.suggestedValuesOnly = this.initShim.suggestedValuesOnly();
        this.initShim = null;
    }

    private ImmutableParameterInfo(ParameterId id, String name, @Nullable String displayName, @Nullable String description, Object defaultValue, @Nullable ParameterDefaultValue defaultValueV1, ParameterType type, boolean allowMultipleValues, boolean hideInDashboard, boolean isMandatory, boolean suggestedValuesOnly, @Nullable DatasetEnumerationInfo enumerationInfo, @Nullable RestrictedViewEnumerationInfo restrictedViewEnumerationInfo, @Nullable TableEnumerationInfo tableEnumerationInfo, List<String> manualEnumeration, boolean active) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.defaultValue = defaultValue;
        this.defaultValueV1 = defaultValueV1;
        this.type = type;
        this.allowMultipleValues = allowMultipleValues;
        this.hideInDashboard = hideInDashboard;
        this.isMandatory = isMandatory;
        this.suggestedValuesOnly = suggestedValuesOnly;
        this.enumerationInfo = enumerationInfo;
        this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo;
        this.tableEnumerationInfo = tableEnumerationInfo;
        this.manualEnumeration = manualEnumeration;
        this.active = active;
        this.initShim = null;
    }

    private boolean allowMultipleValuesInitialize() {
        return ParameterInfo.super.allowMultipleValues();
    }

    private boolean hideInDashboardInitialize() {
        return ParameterInfo.super.hideInDashboard();
    }

    private boolean isMandatoryInitialize() {
        return ParameterInfo.super.isMandatory();
    }

    private boolean suggestedValuesOnlyInitialize() {
        return ParameterInfo.super.suggestedValuesOnly();
    }

    @Override
    @JsonProperty(value="id")
    public ParameterId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="displayName")
    public Optional<String> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="defaultValue")
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty(value="defaultValueV1")
    public Optional<ParameterDefaultValue> defaultValueV1() {
        return Optional.ofNullable(this.defaultValueV1);
    }

    @Override
    @JsonProperty(value="type")
    public ParameterType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="allowMultipleValues")
    public boolean allowMultipleValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowMultipleValues() : this.allowMultipleValues;
    }

    @Override
    @JsonProperty(value="hideInDashboard")
    public boolean hideInDashboard() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hideInDashboard() : this.hideInDashboard;
    }

    @Override
    @JsonProperty(value="isMandatory")
    public boolean isMandatory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMandatory() : this.isMandatory;
    }

    @Override
    @JsonProperty(value="suggestedValuesOnly")
    public boolean suggestedValuesOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.suggestedValuesOnly() : this.suggestedValuesOnly;
    }

    @Override
    @JsonProperty(value="enumerationInfo")
    public Optional<DatasetEnumerationInfo> enumerationInfo() {
        return Optional.ofNullable(this.enumerationInfo);
    }

    @Override
    @JsonProperty(value="restrictedViewEnumerationInfo")
    public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo() {
        return Optional.ofNullable(this.restrictedViewEnumerationInfo);
    }

    @Override
    @JsonProperty(value="tableEnumerationInfo")
    public Optional<TableEnumerationInfo> tableEnumerationInfo() {
        return Optional.ofNullable(this.tableEnumerationInfo);
    }

    @Override
    @JsonProperty(value="manualEnumeration")
    public List<String> manualEnumeration() {
        return this.manualEnumeration;
    }

    @Override
    @JsonProperty(value="active")
    public boolean active() {
        return this.active;
    }

    public final ImmutableParameterInfo withId(ParameterId value) {
        if (this.id == value) {
            return this;
        }
        ParameterId newValue = Objects.requireNonNull(value, "id");
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(newValue, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, newValue, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (Objects.equals(this.displayName, newValue)) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, newValue, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDisplayName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, value, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, newValue, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, value, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDefaultValue(Object value) {
        if (this.defaultValue == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "defaultValue");
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, newValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDefaultValueV1(ParameterDefaultValue value) {
        ParameterDefaultValue newValue = Objects.requireNonNull(value, "defaultValueV1");
        if (this.defaultValueV1 == newValue) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, newValue, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withDefaultValueV1(Optional<? extends ParameterDefaultValue> optional) {
        ParameterDefaultValue value = optional.orElse(null);
        if (this.defaultValueV1 == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, value, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withType(ParameterType value) {
        ParameterType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, newValue, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withAllowMultipleValues(boolean value) {
        if (this.allowMultipleValues == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, value, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withHideInDashboard(boolean value) {
        if (this.hideInDashboard == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, value, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withIsMandatory(boolean value) {
        if (this.isMandatory == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, value, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withSuggestedValuesOnly(boolean value) {
        if (this.suggestedValuesOnly == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, value, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withEnumerationInfo(DatasetEnumerationInfo value) {
        DatasetEnumerationInfo newValue = Objects.requireNonNull(value, "enumerationInfo");
        if (this.enumerationInfo == newValue) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, newValue, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withEnumerationInfo(Optional<? extends DatasetEnumerationInfo> optional) {
        DatasetEnumerationInfo value = optional.orElse(null);
        if (this.enumerationInfo == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, value, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withRestrictedViewEnumerationInfo(RestrictedViewEnumerationInfo value) {
        RestrictedViewEnumerationInfo newValue = Objects.requireNonNull(value, "restrictedViewEnumerationInfo");
        if (this.restrictedViewEnumerationInfo == newValue) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, newValue, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withRestrictedViewEnumerationInfo(Optional<? extends RestrictedViewEnumerationInfo> optional) {
        RestrictedViewEnumerationInfo value = optional.orElse(null);
        if (this.restrictedViewEnumerationInfo == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, value, this.tableEnumerationInfo, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withTableEnumerationInfo(TableEnumerationInfo value) {
        TableEnumerationInfo newValue = Objects.requireNonNull(value, "tableEnumerationInfo");
        if (this.tableEnumerationInfo == newValue) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, newValue, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withTableEnumerationInfo(Optional<? extends TableEnumerationInfo> optional) {
        TableEnumerationInfo value = optional.orElse(null);
        if (this.tableEnumerationInfo == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, value, this.manualEnumeration, this.active));
    }

    public final ImmutableParameterInfo withManualEnumeration(String ... elements) {
        List<String> newValue = ImmutableParameterInfo.createUnmodifiableList(false, ImmutableParameterInfo.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, newValue, this.active));
    }

    public final ImmutableParameterInfo withManualEnumeration(Iterable<String> elements) {
        if (this.manualEnumeration == elements) {
            return this;
        }
        List<String> newValue = ImmutableParameterInfo.createUnmodifiableList(false, ImmutableParameterInfo.createSafeList(elements, true, false));
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, newValue, this.active));
    }

    public final ImmutableParameterInfo withActive(boolean value) {
        if (this.active == value) {
            return this;
        }
        return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this.id, this.name, this.displayName, this.description, this.defaultValue, this.defaultValueV1, this.type, this.allowMultipleValues, this.hideInDashboard, this.isMandatory, this.suggestedValuesOnly, this.enumerationInfo, this.restrictedViewEnumerationInfo, this.tableEnumerationInfo, this.manualEnumeration, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParameterInfo && this.equalTo(0, (ImmutableParameterInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableParameterInfo another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.displayName, another.displayName) && Objects.equals(this.description, another.description) && this.defaultValue.equals(another.defaultValue) && Objects.equals(this.defaultValueV1, another.defaultValueV1) && this.type.equals((Object)another.type) && this.allowMultipleValues == another.allowMultipleValues && this.hideInDashboard == another.hideInDashboard && this.isMandatory == another.isMandatory && this.suggestedValuesOnly == another.suggestedValuesOnly && Objects.equals(this.enumerationInfo, another.enumerationInfo) && Objects.equals(this.restrictedViewEnumerationInfo, another.restrictedViewEnumerationInfo) && Objects.equals(this.tableEnumerationInfo, another.tableEnumerationInfo) && this.manualEnumeration.equals(another.manualEnumeration) && this.active == another.active;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.displayName);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultValueV1);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Boolean.hashCode(this.allowMultipleValues);
        h += (h << 5) + Boolean.hashCode(this.hideInDashboard);
        h += (h << 5) + Boolean.hashCode(this.isMandatory);
        h += (h << 5) + Boolean.hashCode(this.suggestedValuesOnly);
        h += (h << 5) + Objects.hashCode(this.enumerationInfo);
        h += (h << 5) + Objects.hashCode(this.restrictedViewEnumerationInfo);
        h += (h << 5) + Objects.hashCode(this.tableEnumerationInfo);
        h += (h << 5) + this.manualEnumeration.hashCode();
        h += (h << 5) + Boolean.hashCode(this.active);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ParameterInfo{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.displayName != null) {
            builder.append(", ");
            builder.append("displayName=").append(this.displayName);
        }
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("defaultValue=").append(this.defaultValue);
        if (this.defaultValueV1 != null) {
            builder.append(", ");
            builder.append("defaultValueV1=").append(this.defaultValueV1);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("allowMultipleValues=").append(this.allowMultipleValues);
        builder.append(", ");
        builder.append("hideInDashboard=").append(this.hideInDashboard);
        builder.append(", ");
        builder.append("isMandatory=").append(this.isMandatory);
        builder.append(", ");
        builder.append("suggestedValuesOnly=").append(this.suggestedValuesOnly);
        if (this.enumerationInfo != null) {
            builder.append(", ");
            builder.append("enumerationInfo=").append(this.enumerationInfo);
        }
        if (this.restrictedViewEnumerationInfo != null) {
            builder.append(", ");
            builder.append("restrictedViewEnumerationInfo=").append(this.restrictedViewEnumerationInfo);
        }
        if (this.tableEnumerationInfo != null) {
            builder.append(", ");
            builder.append("tableEnumerationInfo=").append(this.tableEnumerationInfo);
        }
        builder.append(", ");
        builder.append("manualEnumeration=").append(this.manualEnumeration);
        builder.append(", ");
        builder.append("active=").append(this.active);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableParameterInfo fromJson(Json json) {
        ParameterInfo.Builder builder = new ParameterInfo.Builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.defaultValue != null) {
            builder.defaultValue(json.defaultValue);
        }
        if (json.defaultValueV1 != null) {
            builder.defaultValueV1(json.defaultValueV1);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.allowMultipleValuesIsSet) {
            builder.allowMultipleValues(json.allowMultipleValues);
        }
        if (json.hideInDashboardIsSet) {
            builder.hideInDashboard(json.hideInDashboard);
        }
        if (json.isMandatoryIsSet) {
            builder.isMandatory(json.isMandatory);
        }
        if (json.suggestedValuesOnlyIsSet) {
            builder.suggestedValuesOnly(json.suggestedValuesOnly);
        }
        if (json.enumerationInfo != null) {
            builder.enumerationInfo(json.enumerationInfo);
        }
        if (json.restrictedViewEnumerationInfo != null) {
            builder.restrictedViewEnumerationInfo(json.restrictedViewEnumerationInfo);
        }
        if (json.tableEnumerationInfo != null) {
            builder.tableEnumerationInfo(json.tableEnumerationInfo);
        }
        if (json.manualEnumeration != null) {
            builder.addAllManualEnumeration(json.manualEnumeration);
        }
        if (json.activeIsSet) {
            builder.active(json.active);
        }
        return builder.build();
    }

    private static ImmutableParameterInfo validate(ImmutableParameterInfo instance) {
        instance.check();
        return instance;
    }

    public static ImmutableParameterInfo copyOf(ParameterInfo instance) {
        if (instance instanceof ImmutableParameterInfo) {
            return (ImmutableParameterInfo)instance;
        }
        return new ParameterInfo.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ParameterInfo", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DEFAULT_VALUE = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_ACTIVE = 16L;
        private static final long OPT_BIT_ALLOW_MULTIPLE_VALUES = 1L;
        private static final long OPT_BIT_HIDE_IN_DASHBOARD = 2L;
        private static final long OPT_BIT_IS_MANDATORY = 4L;
        private static final long OPT_BIT_SUGGESTED_VALUES_ONLY = 8L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private ParameterId id;
        @Nullable
        private String name;
        @Nullable
        private String displayName;
        @Nullable
        private String description;
        @Nullable
        private Object defaultValue;
        @Nullable
        private ParameterDefaultValue defaultValueV1;
        @Nullable
        private ParameterType type;
        private boolean allowMultipleValues;
        private boolean hideInDashboard;
        private boolean isMandatory;
        private boolean suggestedValuesOnly;
        @Nullable
        private DatasetEnumerationInfo enumerationInfo;
        @Nullable
        private RestrictedViewEnumerationInfo restrictedViewEnumerationInfo;
        @Nullable
        private TableEnumerationInfo tableEnumerationInfo;
        private List<String> manualEnumeration = new ArrayList<String>();
        private boolean active;

        public Builder() {
            if (!(this instanceof ParameterInfo.Builder)) {
                throw new UnsupportedOperationException("Use: new ParameterInfo.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder from(ParameterInfo instance) {
            Optional<TableEnumerationInfo> tableEnumerationInfoOptional;
            Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfoOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            Optional<String> displayNameOptional = instance.displayName();
            if (displayNameOptional.isPresent()) {
                this.displayName(displayNameOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.defaultValue(instance.defaultValue());
            Optional<ParameterDefaultValue> defaultValueV1Optional = instance.defaultValueV1();
            if (defaultValueV1Optional.isPresent()) {
                this.defaultValueV1(defaultValueV1Optional);
            }
            this.type(instance.type());
            this.allowMultipleValues(instance.allowMultipleValues());
            this.hideInDashboard(instance.hideInDashboard());
            this.isMandatory(instance.isMandatory());
            this.suggestedValuesOnly(instance.suggestedValuesOnly());
            Optional<DatasetEnumerationInfo> enumerationInfoOptional = instance.enumerationInfo();
            if (enumerationInfoOptional.isPresent()) {
                this.enumerationInfo(enumerationInfoOptional);
            }
            if ((restrictedViewEnumerationInfoOptional = instance.restrictedViewEnumerationInfo()).isPresent()) {
                this.restrictedViewEnumerationInfo(restrictedViewEnumerationInfoOptional);
            }
            if ((tableEnumerationInfoOptional = instance.tableEnumerationInfo()).isPresent()) {
                this.tableEnumerationInfo(tableEnumerationInfoOptional);
            }
            this.addAllManualEnumeration(instance.manualEnumeration());
            this.active(instance.active());
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder id(ParameterId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="displayName")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder displayName(Optional<String> displayName) {
            this.displayName = displayName.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="defaultValue")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder defaultValue(Object defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder defaultValueV1(ParameterDefaultValue defaultValueV1) {
            this.defaultValueV1 = Objects.requireNonNull(defaultValueV1, "defaultValueV1");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="defaultValueV1")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder defaultValueV1(Optional<? extends ParameterDefaultValue> defaultValueV1) {
            this.defaultValueV1 = defaultValueV1.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder type(ParameterType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="allowMultipleValues")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder allowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.optBits |= 1L;
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="hideInDashboard")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder hideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.optBits |= 2L;
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="isMandatory")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder isMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.optBits |= 4L;
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="suggestedValuesOnly")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder suggestedValuesOnly(boolean suggestedValuesOnly) {
            this.suggestedValuesOnly = suggestedValuesOnly;
            this.optBits |= 8L;
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder enumerationInfo(DatasetEnumerationInfo enumerationInfo) {
            this.enumerationInfo = Objects.requireNonNull(enumerationInfo, "enumerationInfo");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="enumerationInfo")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder enumerationInfo(Optional<? extends DatasetEnumerationInfo> enumerationInfo) {
            this.enumerationInfo = enumerationInfo.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder restrictedViewEnumerationInfo(RestrictedViewEnumerationInfo restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = Objects.requireNonNull(restrictedViewEnumerationInfo, "restrictedViewEnumerationInfo");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="restrictedViewEnumerationInfo")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder restrictedViewEnumerationInfo(Optional<? extends RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder tableEnumerationInfo(TableEnumerationInfo tableEnumerationInfo) {
            this.tableEnumerationInfo = Objects.requireNonNull(tableEnumerationInfo, "tableEnumerationInfo");
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="tableEnumerationInfo")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder tableEnumerationInfo(Optional<? extends TableEnumerationInfo> tableEnumerationInfo) {
            this.tableEnumerationInfo = tableEnumerationInfo.orElse(null);
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder addManualEnumeration(String element) {
            this.manualEnumeration.add(Objects.requireNonNull(element, "manualEnumeration element"));
            return (ParameterInfo.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder addManualEnumeration(String ... elements) {
            for (String element : elements) {
                this.manualEnumeration.add(Objects.requireNonNull(element, "manualEnumeration element"));
            }
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="manualEnumeration")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder manualEnumeration(Iterable<String> elements) {
            this.manualEnumeration.clear();
            return this.addAllManualEnumeration(elements);
        }

        @CanIgnoreReturnValue
        public final ParameterInfo.Builder addAllManualEnumeration(Iterable<String> elements) {
            for (String element : elements) {
                this.manualEnumeration.add(Objects.requireNonNull(element, "manualEnumeration element"));
            }
            return (ParameterInfo.Builder)this;
        }

        @JsonProperty(value="active")
        @CanIgnoreReturnValue
        public final ParameterInfo.Builder active(boolean active) {
            this.active = active;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (ParameterInfo.Builder)this;
        }

        public ImmutableParameterInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableParameterInfo.validate(new ImmutableParameterInfo(this));
        }

        private boolean allowMultipleValuesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean hideInDashboardIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isMandatoryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean suggestedValuesOnlyIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("active");
            }
            return "Cannot build ParameterInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ParameterInfo", generator="Immutables")
    static final class Json
    implements ParameterInfo {
        @Nullable
        ParameterId id;
        @Nullable
        String name;
        @Nullable
        Optional<String> displayName = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Object defaultValue;
        @Nullable
        Optional<ParameterDefaultValue> defaultValueV1 = Optional.empty();
        @Nullable
        ParameterType type;
        boolean allowMultipleValues;
        boolean allowMultipleValuesIsSet;
        boolean hideInDashboard;
        boolean hideInDashboardIsSet;
        boolean isMandatory;
        boolean isMandatoryIsSet;
        boolean suggestedValuesOnly;
        boolean suggestedValuesOnlyIsSet;
        @Nullable
        Optional<DatasetEnumerationInfo> enumerationInfo = Optional.empty();
        @Nullable
        Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo = Optional.empty();
        @Nullable
        Optional<TableEnumerationInfo> tableEnumerationInfo = Optional.empty();
        @Nullable
        List<String> manualEnumeration = Collections.emptyList();
        boolean active;
        boolean activeIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(ParameterId id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(Optional<String> displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="defaultValue")
        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @JsonProperty(value="defaultValueV1")
        public void setDefaultValueV1(Optional<ParameterDefaultValue> defaultValueV1) {
            this.defaultValueV1 = defaultValueV1;
        }

        @JsonProperty(value="type")
        public void setType(ParameterType type) {
            this.type = type;
        }

        @JsonProperty(value="allowMultipleValues")
        public void setAllowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.allowMultipleValuesIsSet = true;
        }

        @JsonProperty(value="hideInDashboard")
        public void setHideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.hideInDashboardIsSet = true;
        }

        @JsonProperty(value="isMandatory")
        public void setIsMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.isMandatoryIsSet = true;
        }

        @JsonProperty(value="suggestedValuesOnly")
        public void setSuggestedValuesOnly(boolean suggestedValuesOnly) {
            this.suggestedValuesOnly = suggestedValuesOnly;
            this.suggestedValuesOnlyIsSet = true;
        }

        @JsonProperty(value="enumerationInfo")
        public void setEnumerationInfo(Optional<DatasetEnumerationInfo> enumerationInfo) {
            this.enumerationInfo = enumerationInfo;
        }

        @JsonProperty(value="restrictedViewEnumerationInfo")
        public void setRestrictedViewEnumerationInfo(Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo) {
            this.restrictedViewEnumerationInfo = restrictedViewEnumerationInfo;
        }

        @JsonProperty(value="tableEnumerationInfo")
        public void setTableEnumerationInfo(Optional<TableEnumerationInfo> tableEnumerationInfo) {
            this.tableEnumerationInfo = tableEnumerationInfo;
        }

        @JsonProperty(value="manualEnumeration")
        public void setManualEnumeration(List<String> manualEnumeration) {
            this.manualEnumeration = manualEnumeration;
        }

        @JsonProperty(value="active")
        public void setActive(boolean active) {
            this.active = active;
            this.activeIsSet = true;
        }

        @Override
        public ParameterId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> displayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object defaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ParameterDefaultValue> defaultValueV1() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ParameterType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean allowMultipleValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hideInDashboard() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMandatory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean suggestedValuesOnly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DatasetEnumerationInfo> enumerationInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TableEnumerationInfo> tableEnumerationInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> manualEnumeration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean active() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ParameterInfo", generator="Immutables")
    private final class InitShim {
        private byte allowMultipleValuesBuildStage = 0;
        private boolean allowMultipleValues;
        private byte hideInDashboardBuildStage = 0;
        private boolean hideInDashboard;
        private byte isMandatoryBuildStage = 0;
        private boolean isMandatory;
        private byte suggestedValuesOnlyBuildStage = 0;
        private boolean suggestedValuesOnly;

        private InitShim() {
        }

        boolean allowMultipleValues() {
            if (this.allowMultipleValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowMultipleValuesBuildStage == 0) {
                this.allowMultipleValuesBuildStage = (byte)-1;
                this.allowMultipleValues = ImmutableParameterInfo.this.allowMultipleValuesInitialize();
                this.allowMultipleValuesBuildStage = 1;
            }
            return this.allowMultipleValues;
        }

        void allowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.allowMultipleValuesBuildStage = 1;
        }

        boolean hideInDashboard() {
            if (this.hideInDashboardBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hideInDashboardBuildStage == 0) {
                this.hideInDashboardBuildStage = (byte)-1;
                this.hideInDashboard = ImmutableParameterInfo.this.hideInDashboardInitialize();
                this.hideInDashboardBuildStage = 1;
            }
            return this.hideInDashboard;
        }

        void hideInDashboard(boolean hideInDashboard) {
            this.hideInDashboard = hideInDashboard;
            this.hideInDashboardBuildStage = 1;
        }

        boolean isMandatory() {
            if (this.isMandatoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMandatoryBuildStage == 0) {
                this.isMandatoryBuildStage = (byte)-1;
                this.isMandatory = ImmutableParameterInfo.this.isMandatoryInitialize();
                this.isMandatoryBuildStage = 1;
            }
            return this.isMandatory;
        }

        void isMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.isMandatoryBuildStage = 1;
        }

        boolean suggestedValuesOnly() {
            if (this.suggestedValuesOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.suggestedValuesOnlyBuildStage == 0) {
                this.suggestedValuesOnlyBuildStage = (byte)-1;
                this.suggestedValuesOnly = ImmutableParameterInfo.this.suggestedValuesOnlyInitialize();
                this.suggestedValuesOnlyBuildStage = 1;
            }
            return this.suggestedValuesOnly;
        }

        void suggestedValuesOnly(boolean suggestedValuesOnly) {
            this.suggestedValuesOnly = suggestedValuesOnly;
            this.suggestedValuesOnlyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allowMultipleValuesBuildStage == -1) {
                attributes.add("allowMultipleValues");
            }
            if (this.hideInDashboardBuildStage == -1) {
                attributes.add("hideInDashboard");
            }
            if (this.isMandatoryBuildStage == -1) {
                attributes.add("isMandatory");
            }
            if (this.suggestedValuesOnlyBuildStage == -1) {
                attributes.add("suggestedValuesOnly");
            }
            return "Cannot build ParameterInfo, attribute initializers form cycle " + attributes;
        }
    }
}

