/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.SafeArg;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.DatasetEnumerationInfo;
import latitude.api.parameters.ImmutableLocalParameterInfo;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterInfo;
import latitude.api.parameters.ParameterType;
import latitude.api.parameters.RestrictedViewEnumerationInfo;
import latitude.api.parameters.TableEnumerationInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(as=ImmutableLocalParameterInfo.class)
@JsonDeserialize(as=ImmutableLocalParameterInfo.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public interface LocalParameterInfo {
    public ParameterId id();

    public String name();

    public Optional<String> description();

    public Object defaultValue();

    public ParameterType type();

    @Value.Default
    default public boolean allowMultipleValues() {
        return false;
    }

    @Value.Default
    default public boolean usesMultipleValues() {
        return false;
    }

    @Value.Default
    default public boolean hideInDashboard() {
        return false;
    }

    public Optional<DatasetEnumerationInfo> enumerationInfo();

    public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo();

    public Optional<TableEnumerationInfo> tableEnumerationInfo();

    @Value.Check
    default public void check() {
        ContourExceptions.server500Precondition(!(this.enumerationInfo().isPresent() && this.restrictedViewEnumerationInfo().isPresent() || this.enumerationInfo().isPresent() && this.tableEnumerationInfo().isPresent() || this.restrictedViewEnumerationInfo().isPresent() && this.tableEnumerationInfo().isPresent()), "At most one of dataset, restricted view or table enumeration info should be set", SafeArg.of("isEnumerationInfoPresent", this.enumerationInfo().isPresent()), SafeArg.of("isRestrictedViewEnumerationInfoPresent", this.restrictedViewEnumerationInfo().isPresent()), SafeArg.of("isTableEnumerationInfoPresent", this.tableEnumerationInfo().isPresent()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LocalParameterInfo string(String name, String value) {
        return LocalParameterInfo.string(ParameterId.create(), name, value);
    }

    public static LocalParameterInfo string(ParameterId id, String name, String value) {
        return LocalParameterInfo.builder().id(id).type(ParameterType.STRING).name(name).defaultValue(value).build();
    }

    public static LocalParameterInfo from(ParameterInfo parameterInfo) {
        return LocalParameterInfo.builder().id(parameterInfo.id()).type(parameterInfo.type()).name(parameterInfo.name()).defaultValue(parameterInfo.defaultValue()).description(parameterInfo.description()).allowMultipleValues(parameterInfo.allowMultipleValues()).hideInDashboard(parameterInfo.hideInDashboard()).enumerationInfo(parameterInfo.enumerationInfo()).restrictedViewEnumerationInfo(parameterInfo.restrictedViewEnumerationInfo()).tableEnumerationInfo(parameterInfo.tableEnumerationInfo()).build();
    }

    public static class Builder
    extends ImmutableLocalParameterInfo.Builder {
    }
}

