/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.LegacyParameterConverter;
import latitude.api.parameters.MakeConcreteMode;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterExceptions;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterMap;
import latitude.api.parameters.ParameterValueNotFoundException;
import latitude.api.parameters.PrefixSuffixParameter;
import latitude.api.parameters.RegexReplaceParameter;
import latitude.api.parameters.RemoveEmptyParameter;
import latitude.api.parameters.SimpleParameter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXTERNAL_PROPERTY, defaultImpl=LegacyParameterConverter.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConcreteValue.class), @JsonSubTypes.Type(value=SimpleParameter.class), @JsonSubTypes.Type(value=PrefixSuffixParameter.class), @JsonSubTypes.Type(value=RegexReplaceParameter.class), @JsonSubTypes.Type(value=RemoveEmptyParameter.class)})
public abstract class Parameter<T> {
    @JsonIgnore
    public abstract boolean isConcrete();

    @JsonIgnore
    public List<? extends Parameter<T>> makeConcrete(ParameterMap parameterMap, Class<T> parameterType, ParameterArity parameterArity, MakeConcreteMode makeConcreteMode) {
        try {
            return this.makeConcreteThrowIfMissing(parameterMap, parameterType, parameterArity);
        }
        catch (ParameterValueNotFoundException e) {
            return Collections.singletonList(this.handleValueNotFound(makeConcreteMode, e));
        }
    }

    @JsonIgnore
    protected abstract List<ConcreteValue<T>> makeConcreteThrowIfMissing(ParameterMap var1, Class<T> var2, ParameterArity var3) throws ParameterValueNotFoundException;

    @JsonIgnore
    public abstract T asConcreteValue();

    @JsonIgnore
    public abstract Optional<ParameterId> getParameterId();

    private Parameter<T> handleValueNotFound(MakeConcreteMode makeConcreteMode, ParameterValueNotFoundException exception) {
        switch (makeConcreteMode) {
            case RETURN_SELF_IF_MISSING_VALUE: {
                return this;
            }
            case FAIL_IF_MISSING_VALUE: {
                throw ParameterExceptions.parameterValueNotFound(exception);
            }
        }
        throw ContourExceptions.server500IllegalEnum(makeConcreteMode);
    }
}

