/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import latitude.api.exception.AbstractExceptionManager;
import latitude.api.exception.ErrorName;
import latitude.api.parameters.ParameterValueNotFoundException;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ErrorType;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.ServiceException;

public final class ParameterExceptions
extends AbstractExceptionManager {
    private static final ErrorType PARAMETER_VALUE_NOT_FOUND = ErrorType.create(ErrorType.Code.NOT_FOUND, ErrorName.PARAMETER_VALUE_NOT_FOUND.toString());

    private ParameterExceptions() {
    }

    public static ServiceException parameterValueNotFound(ParameterValueNotFoundException pvnfException) {
        return new ServiceException(PARAMETER_VALUE_NOT_FOUND, ParameterExceptions.safeUserMessage(pvnfException.getMessage()), SafeArg.of("missingParameterId", pvnfException.getMissingParameterId()), UnsafeArg.of("availableParameters", pvnfException.getAvailableParameters()));
    }
}

