/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import java.util.Objects;
import java.util.UUID;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;

public final class ParameterId
implements Comparable<ParameterId> {
    private final UUID id;

    @JsonCreator
    public ParameterId(@JsonProperty(value="id") UUID id) {
        this.id = id;
    }

    @JsonCreator
    public static ParameterId fromString(String uuid) {
        return new ParameterId(UUID.fromString(uuid));
    }

    public static ParameterId valueOf(String uuid) {
        return ParameterId.fromString(uuid);
    }

    public UUID getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterId other = (ParameterId)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String toString() {
        return "" + this.id;
    }

    public static ParameterId create() {
        return new ParameterId(UUID.randomUUID());
    }

    @Override
    public int compareTo(ParameterId other) {
        return this.getId().compareTo(other.getId());
    }
}

