/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import java.util.List;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.DatasetEnumerationInfo;
import latitude.api.parameters.ImmutableParameterInfo;
import latitude.api.parameters.ParameterDefaultValue;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterType;
import latitude.api.parameters.RestrictedViewEnumerationInfo;
import latitude.api.parameters.TableEnumerationInfo;
import latitude.api.parameters.relativedate.RelativeDateDefaultValue;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(as=ImmutableParameterInfo.class)
@JsonDeserialize(as=ImmutableParameterInfo.class)
@Unsafe
@Value.Immutable
public interface ParameterInfo {
    public ParameterId id();

    public String name();

    public Optional<String> displayName();

    public Optional<String> description();

    public Object defaultValue();

    public Optional<ParameterDefaultValue> defaultValueV1();

    public ParameterType type();

    @Value.Default
    default public boolean allowMultipleValues() {
        return false;
    }

    @Value.Default
    default public boolean hideInDashboard() {
        return false;
    }

    @Value.Default
    default public boolean isMandatory() {
        return false;
    }

    @Value.Default
    default public boolean suggestedValuesOnly() {
        return false;
    }

    public Optional<DatasetEnumerationInfo> enumerationInfo();

    public Optional<RestrictedViewEnumerationInfo> restrictedViewEnumerationInfo();

    public Optional<TableEnumerationInfo> tableEnumerationInfo();

    public List<String> manualEnumeration();

    public boolean active();

    @Value.Check
    default public void check() {
        ContourExceptions.client400PreconditionWithSafeMessage(!(this.enumerationInfo().isPresent() && this.restrictedViewEnumerationInfo().isPresent() || this.enumerationInfo().isPresent() && this.tableEnumerationInfo().isPresent() || this.restrictedViewEnumerationInfo().isPresent() && this.tableEnumerationInfo().isPresent()), "At most one of dataset, restricted view or table enumeration info should be set", SafeArg.of("isEnumerationInfoPresent", this.enumerationInfo().isPresent()), SafeArg.of("isRestrictedViewEnumerationInfoPresent", this.restrictedViewEnumerationInfo().isPresent()), SafeArg.of("isTableEnumerationInfoPresent", this.tableEnumerationInfo().isPresent()));
        ContourExceptions.client400PreconditionWithSafeMessage(!this.defaultValueV1().isPresent() || this.defaultValueV1().get().accept(new ParameterDefaultValue.Visitor<Boolean>(){

            @Override
            public Boolean visit(RelativeDateDefaultValue _value) {
                return true;
            }

            @Override
            public Boolean visit(@Safe String unknownType) {
                throw ContourExceptions.clientUnknownUnionType(unknownType, ParameterDefaultValue.class);
            }
        }) == false || this.type() == ParameterType.DATE, "Relative date parameters must be of date type", SafeArg.of("parameterType", this.type()));
    }

    public static ParameterInfo string(String name, String value) {
        return ParameterInfo.string(ParameterId.create(), name, value);
    }

    public static ParameterInfo string(ParameterId id, String name, String value) {
        return ParameterInfo.builder().id(id).active(true).type(ParameterType.STRING).name(name).defaultValue(value).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableParameterInfo.Builder {
    }
}

