/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import latitude.api.column.ColumnInfo;
import latitude.api.exception.ContourExceptions;
import latitude.api.jackson.ContourJackson;
import latitude.api.parameters.ImmutableParameterMap;
import latitude.api.parameters.LocalParameterInfo;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterInfo;
import latitude.api.parameters.ParameterValueNotFoundException;
import latitude.api.util.CastUtils;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.type.TypeFactory;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.one.util.streamex.AbstractStreamEx;
import shadow.palantir.driver.one.util.streamex.EntryStream;
import shadow.palantir.driver.one.util.streamex.StreamEx;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Value.Immutable
public abstract class ParameterMap {
    private static final String PARAMETERS_FIELD_NAME = "parameters";

    @JsonIgnore
    public Set<ParameterId> getParameterIds() {
        return Collections.unmodifiableSet(this.parameters().keySet());
    }

    @JsonProperty(value="parameters")
    @Value.Parameter
    public abstract Map<ParameterId, Object> parameters();

    @JsonIgnore
    public <T> List<T> getValuesForParameter(ParameterId parameterId, Class<T> clazz, ParameterArity arity) throws ParameterValueNotFoundException {
        Object value = this.getObjectForParameterChecked(parameterId);
        switch (arity) {
            case SINGLE_VALUE: {
                return this.listAsSingleValEmptyStringAsNull(value, clazz);
            }
            case MULTIPLE_VALUES: {
                return this.listAsMultipleValuesEmptyStringAsNull(value, clazz);
            }
        }
        throw ContourExceptions.server500IllegalEnum(arity);
    }

    @JsonIgnore
    public boolean hasValueForParameter(ParameterId parameterId) {
        return this.parameters().containsKey(parameterId);
    }

    @JsonIgnore
    public ParameterMap mergedKeepExisting(ParameterMap otherMap) {
        Map<ParameterId, Object> newParameters = ((StreamEx)StreamEx.of(otherMap.getParameterIds()).remove(this::hasValueForParameter)).mapToEntry(id -> otherMap.parameters().get(id)).nonNullValues().append(this.parameters()).toMap();
        return ParameterMap.of(newParameters);
    }

    @JsonIgnore
    public ParameterMap retainOnly(Collection<ParameterId> idsToBeRetained) {
        Map<ParameterId, Object> newParameters = EntryStream.of(this.parameters()).filterKeys(idsToBeRetained::contains).toMap();
        return ParameterMap.of(newParameters);
    }

    @JsonIgnore
    private Object getObjectForParameterChecked(ParameterId parameterId) throws ParameterValueNotFoundException {
        if (!this.parameters().containsKey(parameterId)) {
            throw new ParameterValueNotFoundException(parameterId, this.parameters());
        }
        return this.parameters().get(parameterId);
    }

    @JsonIgnore
    private <T> List<T> listAsMultipleValuesEmptyStringAsNull(Object value, Class<T> clazz) {
        if (value instanceof List) {
            return ((AbstractStreamEx)StreamEx.of((List)value).map(item -> CastUtils.safeCastObjectAsClass(item, clazz))).toList();
        }
        return this.listAsSingleValEmptyStringAsNull(value, clazz);
    }

    @JsonIgnore
    private <T> List<T> listAsSingleValEmptyStringAsNull(Object value, Class<T> clazz) {
        if (value instanceof String && ((String)value).isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of(CastUtils.safeCastObjectAsClass(value, clazz));
    }

    public static ParameterMap empty() {
        return ImmutableParameterMap.builder().build();
    }

    public static ParameterMap of(Map<? extends ParameterId, ?> parameters) {
        return ImmutableParameterMap.of(parameters);
    }

    public static ParameterMap from(Collection<ParameterInfo> parameters) {
        Map<ParameterId, Object> map = StreamEx.of(parameters).toMap(ParameterInfo::id, ParameterInfo::defaultValue);
        return ImmutableParameterMap.of(map);
    }

    public static ParameterMap fromLocalParameterInfo(Collection<LocalParameterInfo> parameters) {
        Map<ParameterId, Object> map = StreamEx.of(parameters).toMap(LocalParameterInfo::id, LocalParameterInfo::defaultValue);
        return ImmutableParameterMap.of(map);
    }

    private static Object tryConvertMapToColumnInfo(Object value) {
        if (value instanceof Map) {
            return ContourJackson.getObjectMapper().convertValue(value, ColumnInfo.class);
        }
        return value;
    }

    private static Object tryConvertColumnInfoToMap(Object value) {
        if (value instanceof ColumnInfo) {
            return ContourJackson.getObjectMapper().convertValue(value, TypeFactory.defaultInstance().constructMapType(Map.class, Object.class, Object.class));
        }
        return value;
    }

    public static class Serializer
    extends JsonSerializer<Object> {
        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider _serializers) throws IOException {
            Map<ParameterId, Object> parameters = EntryStream.of(((ParameterMap)value).parameters()).mapValues(val -> {
                if (val instanceof List) {
                    return ((List)val).stream().map(x$0 -> ParameterMap.tryConvertColumnInfoToMap(x$0)).collect(Collectors.toList());
                }
                return ParameterMap.tryConvertColumnInfoToMap(val);
            }).toMap();
            gen.writeStartObject();
            gen.writeObjectField(ParameterMap.PARAMETERS_FIELD_NAME, parameters);
            gen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Object> {
        @Override
        public Object deserialize(JsonParser parser, DeserializationContext _context) throws IOException {
            Object tree = parser.readValueAsTree();
            String content = tree.get(ParameterMap.PARAMETERS_FIELD_NAME).toString();
            TypeReference<Map<ParameterId, Object>> typeRef = new TypeReference<Map<ParameterId, Object>>(){};
            Map<ParameterId, Object> parameters = ContourJackson.getObjectMapper().readValue(content, typeRef);
            parameters = EntryStream.of(parameters).mapValues(val -> {
                if (val instanceof List) {
                    return ((List)val).stream().map(x$0 -> ParameterMap.tryConvertMapToColumnInfo(x$0)).collect(Collectors.toList());
                }
                return ParameterMap.tryConvertMapToColumnInfo(val);
            }).toMap();
            return ImmutableParameterMap.of(parameters);
        }
    }
}

