/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.ImmutablePrefixSuffixParameter;
import latitude.api.parameters.Parameter;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterMap;
import latitude.api.parameters.ParameterValueNotFoundException;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutablePrefixSuffixParameter.class)
@JsonSerialize(as=ImmutablePrefixSuffixParameter.class)
@JsonTypeName(value="prefix-suffix")
@Value.Immutable
public abstract class PrefixSuffixParameter
extends Parameter<String> {
    @Value.Parameter
    public abstract Parameter<String> parameter();

    @Value.Parameter
    public abstract String prefix();

    @Value.Parameter
    public abstract String suffix();

    @Override
    public final boolean isConcrete() {
        return false;
    }

    @Override
    public final String asConcreteValue() {
        throw ContourExceptions.server500("PrefixSuffixParameter is not concrete!", new Arg[0]);
    }

    @Override
    protected final List<ConcreteValue<String>> makeConcreteThrowIfMissing(ParameterMap parameterMap, Class<String> parameterType, ParameterArity arity) throws ParameterValueNotFoundException {
        ContourExceptions.server500Precondition(parameterType == String.class, "PrefixSuffixParameter only supports strings, but was given a different type.", SafeArg.of("className", parameterType.getSimpleName()));
        return this.parameter().makeConcreteThrowIfMissing(parameterMap, String.class, arity).stream().map(this::addPrefixes).collect(Collectors.toList());
    }

    private ConcreteValue<String> addPrefixes(ConcreteValue<String> original) {
        return ConcreteValue.of(this.prefix() + original.value() + this.suffix());
    }

    @Override
    public final Optional<ParameterId> getParameterId() {
        return this.parameter().getParameterId();
    }

    public static PrefixSuffixParameter of(Parameter<String> parameter, String prefix, String suffix) {
        return ImmutablePrefixSuffixParameter.of(parameter, prefix, suffix);
    }
}

