/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.ImmutableRegexReplaceParameter;
import latitude.api.parameters.Parameter;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterMap;
import latitude.api.parameters.ParameterValueNotFoundException;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRegexReplaceParameter.class)
@JsonSerialize(as=ImmutableRegexReplaceParameter.class)
@JsonTypeName(value="regex-replace")
@Value.Immutable
public abstract class RegexReplaceParameter
extends Parameter<String> {
    @Value.Parameter
    public abstract Parameter<String> parameter();

    @Value.Parameter
    public abstract String regex();

    @Value.Parameter
    public abstract String replacementValue();

    @Override
    public final boolean isConcrete() {
        return false;
    }

    @Override
    public final String asConcreteValue() {
        throw ContourExceptions.server500("RegexReplaceParameter is not concrete!", new Arg[0]);
    }

    @Override
    protected List<ConcreteValue<String>> makeConcreteThrowIfMissing(ParameterMap parameterMap, Class<String> parameterType, ParameterArity parameterArity) throws ParameterValueNotFoundException {
        ContourExceptions.server500Precondition(parameterType == String.class, "RegexReplaceParameter only supports strings, but was given a different type.", SafeArg.of("className", parameterType.getSimpleName()));
        return this.parameter().makeConcreteThrowIfMissing(parameterMap, String.class, parameterArity).stream().map(this::doRegexReplacement).collect(Collectors.toList());
    }

    private ConcreteValue<String> doRegexReplacement(ConcreteValue<String> original) {
        return ConcreteValue.of(original.value().replaceAll(this.regex(), this.replacementValue()));
    }

    @Override
    public final Optional<ParameterId> getParameterId() {
        return this.parameter().getParameterId();
    }

    public static RegexReplaceParameter of(Parameter<String> parameter, String regex, String replacementValue) {
        return ImmutableRegexReplaceParameter.of(parameter, regex, replacementValue);
    }
}

