/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.ImmutableRemoveEmptyParameter;
import latitude.api.parameters.Parameter;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterMap;
import latitude.api.parameters.ParameterValueNotFoundException;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRemoveEmptyParameter.class)
@JsonSerialize(as=ImmutableRemoveEmptyParameter.class)
@JsonTypeName(value="remove-empty")
@Value.Immutable
public abstract class RemoveEmptyParameter
extends Parameter<String> {
    @Value.Parameter
    public abstract Parameter<String> parameter();

    @Override
    public final boolean isConcrete() {
        return false;
    }

    @Override
    public final String asConcreteValue() {
        throw ContourExceptions.server500("RemoveEmptyParameter is not concrete!", new Arg[0]);
    }

    @Override
    public final List<ConcreteValue<String>> makeConcreteThrowIfMissing(ParameterMap parameterMap, Class<String> parameterType, ParameterArity arity) throws ParameterValueNotFoundException {
        ContourExceptions.server500Precondition(parameterType == String.class, "RemoveEmptyParameter only supports strings, but was given a different type.", SafeArg.of("className", parameterType.getSimpleName()));
        return this.parameter().makeConcreteThrowIfMissing(parameterMap, String.class, arity).stream().filter(this::filterOutEmpty).collect(Collectors.toList());
    }

    private boolean filterOutEmpty(ConcreteValue<String> original) {
        return !original.value().isEmpty();
    }

    @Override
    public final Optional<ParameterId> getParameterId() {
        return this.parameter().getParameterId();
    }

    public static RemoveEmptyParameter of(Parameter<String> parameter) {
        return ImmutableRemoveEmptyParameter.of(parameter);
    }
}

