/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters;

import com.palantir.logsafe.Arg;
import java.util.List;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.parameters.ConcreteValue;
import latitude.api.parameters.ImmutableSimpleParameter;
import latitude.api.parameters.Parameter;
import latitude.api.parameters.ParameterArity;
import latitude.api.parameters.ParameterId;
import latitude.api.parameters.ParameterMap;
import latitude.api.parameters.ParameterValueNotFoundException;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.one.util.streamex.AbstractStreamEx;
import shadow.palantir.driver.one.util.streamex.StreamEx;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableSimpleParameter.class)
@JsonSerialize(as=ImmutableSimpleParameter.class)
@JsonTypeName(value="simple")
@Value.Immutable
public abstract class SimpleParameter<T>
extends Parameter<T> {
    @Value.Parameter
    public abstract ParameterId parameterId();

    @Override
    public final boolean isConcrete() {
        return false;
    }

    @Override
    public final T asConcreteValue() {
        throw ContourExceptions.server500("SimpleParameter is not concrete!", new Arg[0]);
    }

    @Override
    protected final List<ConcreteValue<T>> makeConcreteThrowIfMissing(ParameterMap parameterMap, Class<T> paramType, ParameterArity parameterArity) throws ParameterValueNotFoundException {
        return ((AbstractStreamEx)StreamEx.of(parameterMap.getValuesForParameter(this.parameterId(), paramType, parameterArity)).map(ConcreteValue::of)).toList();
    }

    @Override
    public final Optional<ParameterId> getParameterId() {
        return Optional.of(this.parameterId());
    }

    public static <T> SimpleParameter<T> of(ParameterId parameterId) {
        return ImmutableSimpleParameter.of(parameterId);
    }
}

